PRAGMA yt.InferSchema;
PRAGMA yt.QueryCacheMode = "normal";

{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$watchlog_data = (
    select
        uniqid,
        Url::GetCGIParam(url, "ymclid") as ymclid,
        CAST(unixtime as Int64) as last_seen,
        domainuserid as fpc,
        UserAgent::Parse(useragent).OSVersion as osversion,
        UserAgent::Parse(useragent).OSFamily as osfamily,
        Url::GetHost(Url::Normalize(url)) as original_domain,
        $cut_domain_from_url(url) as domain,
        UserAgent::Parse(useragent).BrowserName as browser_name,
        UserAgent::Parse(useragent).BrowserVersion as browser_version,
    FROM
        CONCAT({{input_watch_tables}})
    where
        $is_good_useragent(useragent)
        and counterid ?? '0' not in ('3', '48547472')
        and Metrika::ParseBrowserinfo(browserinfo)['pv']=='1'
        and $https_match(url)
        and $is_good_domain($cut_domain_from_url(url))
        and Url::GetSignificantDomain(referer) != Url::GetSignificantDomain(url)
        and $is_valid_fpc(domainuserid)
        and $not_upload_or_changed(browserinfo) = true
        and $not_gdpr(regionid)
        and (not $is_valid_yuid(uniqid) or uniqid = domainuserid)
        and Url::GetCGIParam(url, "ymclid") is not null
);

$market_data = (
    select
        event_time/1000 as eventtime,
        Url::GetCGIParam(url, "ymclid") as ymclid,
        yandex_uid as yandexuid
    from
        CONCAT({{input_market_tables}})
    where
        $is_good_useragent(user_agent)
        and $is_valid_yuid(yandex_uid)
        and Url::GetCGIParam(url, "ymclid") is not null
);

insert into
    `{{output_table}}` with truncate
select
    'market' as source,
    last_seen,
    original_domain,
    domain,
    fpc as domain_cookie,
    yandexuid as yuid,
    osversion,
    osfamily,
    browser_name,
    browser_version,
    false as seen_you
from
    $watchlog_data as a
inner join
    $market_data as b
using
    (ymclid)
where
    last_seen-eventtime between 0 and 300;
