{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$candidates = (
SELECT
    AGGREGATE_LIST_DISTINCT(
        IF ($is_valid_yuid(uniqid) and not seen_you,
            uniqid,
            null),
            $max_list_values) as uniqids,
    AGGREGATE_LIST_DISTINCT(
        IF (is_good_domain,
            (domain, fpc),
            null),
            $max_list_values) as duids,
    max(last_seen) as last_seen,
    SOME(browser_name) as browser_name,
    SOME(browser_version) as browser_version,
    SOME(osfamily) as osfamily,
    SOME(osversion) as osversion,
FROM
    CONCAT({{input_tables}})
GROUP BY
    mc_port_fip
);

$yuid_duids = (
    select
        $bestYandexuidByTs(uniqids) as yuid,
        "mcport" as source,
        DictItems(ToDict(duids)) as duids,
        last_seen as last_seen,
        osfamily,
        osversion,
        browser_name,
        browser_version
    from
        $candidates
    where
        $bestYandexuidByTs(uniqids) is not null
        and $is_good_list_length(duids, 1, 100)
);

insert into `{{output_table}}`
select
    yuid, source, last_seen, osfamily, osversion, browser_name, browser_version,
    duids.0 as domain, duids.0 as original_domain, duids.1 as domain_cookie,
    $generate_hash(duids.0 || duids.1) as hash, false as seen_you
from $yuid_duids
    flatten list by duids
where
    $is_good_domain(duids.0)
{% if is_embedded %}
order by domain_cookie
{% endif %}
;
