{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$is_valid_domain_duid = ($url, $browserinfo) -> {
    $duid = Metrika::ParseBrowserinfo($browserinfo)['u'];
    $domain = $cut_domain_from_url($url);
    return $is_valid_fpc($duid) and $is_valid_domain($domain);
};

$candidates = (
SELECT
    AGGREGATE_LIST_DISTINCT(
        IF ($is_valid_yuid(uniqid) and not $seen_you(browserinfo) and uniqid != domainuserid,
            uniqid,
            null),
            $max_list_values) as uniqids,
    AGGREGATE_LIST_DISTINCT(
        IF ($is_valid_domain_duid(url, browserinfo),
        ($cut_domain_from_url(url), Metrika::ParseBrowserinfo(browserinfo)['u']),
        null),
        $max_list_values) as duids,
    max(cast(unixtime as UInt64)) as maxtime,
    min(cast(unixtime as UInt64)) as mintime,
    SOME(useragent) as ua,
    SOME(UserAgent::Parse(useragent).BrowserName) as browser_name,
    SOME(UserAgent::Parse(useragent).BrowserVersion) as browser_version,
    SOME(UserAgent::Parse(useragent).OSFamily) as os,
    SOME(UserAgent::Parse(useragent).OSVersion) as os_version,
    sslsessionticketkeyname,
    sslsessionticketiv,
    count(1) as total_matches
FROM
    CONCAT({{input_tables}})
WHERE
    $https_match(url)
    and $is_good_useragent(useragent)
    and $is_valid_domain($cut_domain_from_url(url))
    and $not_upload_or_changed(browserinfo) = true
    and $not_gdpr(regionid)
    and counterid ?? '0' not in ('3', '48547472')
    and Url::GetSignificantDomain(referer) != Url::GetSignificantDomain(url)
    and sslsessionticketkeyname != "" and sslsessionticketiv != ""
GROUP BY
    sslsessionticketiv, sslsessionticketkeyname
);

$yuid_duids = (
    select
        $bestYandexuidByTs(uniqids) as yuid,
        "tls" as source,
        duids,
        maxtime as last_seen,
        os as osfamily,
        os_version as osversion,
        browser_name,
        browser_version
    from
        $candidates
    where
        $bestYandexuidByTs(uniqids) is not null
        and $is_good_list_length(duids, 0, 100)
);

insert into `{{fresh_output_table}}`
select
    yuid, source, last_seen, osfamily, osversion, browser_name, browser_version,
    duids.0 as domain, duids.0 as original_domain, duids.1 as domain_cookie,
    $generate_hash(duids.0 || duids.1) as hash, false as seen_you
from $yuid_duids
    flatten list by duids
where
    $is_good_domain(duids.0)
{% if is_embedded %}
order by domain_cookie
{% endif %}
;
