PRAGMA yt.InferSchema;
PRAGMA yt.QueryCacheMode = "normal";

{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$chevent = (select
        yclid,
        yuid,
        click_time
    from (
        select
            cast(logid AS Uint64) AS yclid,
            cast(uniqid AS Uint64) AS yuid,
            cast(eventtime AS UInt64) AS click_time,
            cast(pageid AS Int64) AS pageid
        from
            concat({{input_chevent_tables}})
        where
            countertype == "2" -- clicks
            and uniqid != cryptaid
        union all
        select
            cast(trackid AS Uint64) AS yclid,
            cast(uniqid AS Uint64) AS yuid,
            cast(eventtime AS UInt64) AS click_time,
            cast(pageid AS Int64) AS pageid
        from
            concat({{input_chevent_tables}})
        where
            countertype == "2"
            and uniqid != cryptaid
    ) as a
    inner join (
        select
            PageID AS pageid
        from
            `{{page_table}}`
        where
            TargetType == 0
    ) as b
    using
        (pageid)
);

$watch = (
    select
        UserAgent::Parse(useragent).OSVersion as osversion,
        UserAgent::Parse(useragent).OSFamily as osfamily,
        UserAgent::Parse(useragent).BrowserName as browser_name,
        UserAgent::Parse(useragent).BrowserVersion as browser_version,
        Url::GetHost(Url::Normalize(url)) as original_domain,
        CAST(Url::GetCGIParam(url, "yclid") as UInt64) ?? 0 as yclid,
        $cut_domain_from_url(url) as domain,
        $get_domain_cookie(browserinfo) as domain_cookie,
        CAST(unixtime as Int64) as last_seen,
        $generate_hash_from_url_and_bi(url, browserinfo) as hash
    from
        concat({{input_watch_tables}})
    where
        $is_good_useragent(useragent)
        and cast(Url::GetCGIParam(url, "yclid") as UInt64) != 0
        and $is_good_domain($cut_domain_from_url(url))
        and $is_valid_fpc($get_domain_cookie(browserinfo))
        and $not_upload_or_changed(browserinfo) = true
        and browserinfo like "%:pv:1%"
        and $not_gdpr(regionid)
);

$yclid_filter = (
    select
        yclid
    from (
        select
            yclid,
            count(distinct domain_cookie) AS domain_cookie_count
        from
            $watch
        group by
            yclid
    )
    where
        domain_cookie_count == 1
);

$watch_combined_and_filtered = (
    select
        *
    from (
        select
            some(osversion) as osversion,
            some(osfamily) as osfamily,
            some(browser_name) as browser_name,
            some(browser_version) as browser_version,
            some(original_domain) as original_domain,
            some(domain) as domain,
            some(domain_cookie) as domain_cookie,
            min(last_seen) AS watch_time,
            hash,
            yclid
        from
            $watch
        group by
            hash,
            yclid
    ) as a
    left join (
        select
            yclid
        from
            $yclid_filter
    ) as b
    using
        (yclid)
);

insert into `{{output_table}}`
select
    osversion,
    osfamily,
    browser_name,
    browser_version,
    original_domain,
    domain,
    domain_cookie,
    watch_time AS last_seen,
    CAST(yuid AS String) AS yuid,
    "click" AS source,
    false as seen_you
from
    $watch_combined_and_filtered as a
inner join
    $chevent as b
using
    (yclid)
where
    watch_time - click_time < 50;
