{% set use_sandbox=False %}

{% if not is_embedded %}
PRAGMA File(
    'libcrypta_identifier_udf.so',
{% if use_sandbox %}
    'https://proxy.sandbox.yandex-team.ru/last/CRYPTA_IDENTIFIERS_UDF?attrs={{ "{" }}"released":"stable"{{ "}" }}&salt={{ now }}'
{% else %}
    'yt://hahn/home/crypta/public/udfs/stable/libcrypta_identifier_udf.so'
{% endif %}
);
PRAGMA Udf('libcrypta_identifier_udf.so');
{% endif %}

$extract_ts = ($yuid) -> {
    $ts = CAST($yuid AS Uint64) % 10000000000UL;
    return CAST($ts AS Int64);
};

$is_valid_fpc = ($duid) -> {
    return Identifiers::IsSignificantDuid($duid)
};

$is_valid_yuid = ($yuid) -> {
    return cast($yuid as String) != "5059465131619120321" and Identifiers::IsValidYandexuid($yuid)
};

$generate_hash = ($v) -> {
    $hash = String::Hex(Digest::MurMurHash($v));
    return String::ToLower(SUBSTRING($hash, 2));
};

$select_older_yuid = ($yuid1, $yuid2) -> {
    $yuid1 = case when $yuid1 is null or $yuid1 = "" then $yuid2 else $yuid1 end;
    $yuid2 = case when $yuid2 is null or $yuid2 = "" then $yuid1 else $yuid2 end;
    $ts1 = $extract_ts($yuid1);
    $ts2 = $extract_ts($yuid2);

    return case
        when $ts1 > $ts2
        then $yuid2
        else
             $yuid1
        end;
};

$get_source_for_older_yuid = ($yuid1, $source1, $yuid2, $source2) -> {
    $older_yuid = $select_older_yuid($yuid1, $yuid2);
    RETURN
    CASE
        WHEN $older_yuid = $yuid1
        THEN $source1
        ELSE $source2
    END;
};

$select_older_yuid_with_source = ($yuid1, $source1, $yuid2, $source2) -> {
    $yuid1 = case when $yuid1 is null or $yuid1 = "" then $yuid2 else $yuid1 end;
    $source1 = case when $source1 is null or $source1 = "" then $source2 else $source1 end;
    $yuid2 = case when $yuid2 is null or $yuid2 = "" then $yuid1 else $yuid2 end;
    $source2 = case when $source2 is null or $source2 = "" then $source1 else $source2 end;

    $ts1 = IF($source1 == "watch", $extract_ts($yuid1) + 1, $extract_ts($yuid1));
    $ts2 = IF($source2 == "watch", $extract_ts($yuid2) + 1, $extract_ts($yuid2));

    return case
        when
             $ts1 > $ts2
        then
             $source2
        else
             $source1
        end;
};
