PRAGMA yt.InferSchema;
PRAGMA yt.QueryCacheMode = "normal";

{% include 'yql/lib.sql' %}

$max_of_with_null = ($v1, $v2) -> {
    $v1 = case when $v1 is null then $v2 else $v1 end;
    $v2 = case when $v2 is null then $v1 else $v2 end;

    return max_of($v1, $v2);
};

$data = (
select
    $max_of_with_null(l.last_seen, r.last_seen) as last_seen,
    coalesce(l.domain, r.domain) as domain,
    $select_older_yuid(l.yuid, r.yuid) as yuid,
    coalesce(l.osfamily, r.osfamily) as osfamily,
    coalesce(l.osversion, r.osversion) as osversion,
    coalesce(l.browser_name, r.browser_name) as browser_name,
    coalesce(l.browser_version, r.browser_version) as browser_version,
    coalesce(l.domain_cookie, r.domain_cookie) as domain_cookie,
    coalesce(l.original_domain, r.original_domain) as original_domain,
    IF (
        seen_you,
        COALESCE(l.source, r.source),
        $select_older_yuid_with_source(l.yuid, l.source, r.yuid, r.source)
    ) AS source
from
    `{{ single_table }}` as l
full join
    `{{ input_table }}` as r
on
    l.domain_cookie = r.domain_cookie
where
    (l.last_seen > {{ last_seen_margin }} or l.last_seen is null)
);

insert into `{{ output_table }}` with truncate
select
    *
from
    $data
where
    yuid is not null
order by
    domain_cookie
;
