{% set use_sandbox=False %}

{% if not is_embedded %}
PRAGMA File(
    'libitp_udf.so',
{% if use_sandbox %}
    'https://proxy.sandbox.yandex-team.ru/last/CRYPTA_ITP_UDF?salt={{ now }}'
{% else %}
    'yt://hahn/home/crypta/public/udfs/unstable/libitp_udf.so'
{% endif %}
);
PRAGMA Udf('libitp_udf.so');
{% endif %}

$get_domain_cookie = ($browserinfo) -> {
    return Metrika::ParseBrowserinfo($browserinfo)["u"]
};

$yandexRegexp_ = Re2::Match(@@(^(.*\.)?((ya.ru)|(yandex\.(com\.)?(ru|com|by|kz|md|am|az|ee|fr|ge|kg|lt|lv|tj|tm|tr|ua|uz)))$)@@);
$is_yandex_domain = ($domain) -> {
    return $yandexRegexp_($domain);
};

-- parse conditions
$is_good_domain = ($domain) -> {
    return case
        when $domain is null
        then False
        when $domain = ""
        then False
        when String::EndsWith($domain, "yastatic.net")
        then False
        when $is_yandex_domain($domain)
        then False
        when not $is_valid_domain($domain)
        then False
        else
            True
    end
};

$is_good_useragent = ($useragent) -> {
    $result = Itp::Itp(COALESCE($useragent, ""));
    $parsed = UserAgent::Parse($useragent);

    $isItp = $result.isItp OR $result.mayBeItp;
    return $isItp AND not $parsed.inAppBrowser AND not $parsed.isRobot AND $parsed.isBrowser;
};

-- hash
$generate_hash_from_url_and_bi = ($url, $browserinfo) -> {
    $v=($cut_domain_from_url($url) || $get_domain_cookie($browserinfo));

    $hash = String::Hex(Digest::MurMurHash($v));
    return String::AsciiToLower(SUBSTRING($hash, 2));
};

-- upload
$not_upload_or_changed = ($browserinfo) -> {
    $parsed = Metrika::ParseBrowserinfo($browserinfo);

    $ln_flag = $parsed["ln"];
    $dl_flag = $parsed["dl"];
    $fu_flag = coalesce($parsed["fu"], '0');
    $is_turbo = coalesce($parsed["tp"], '0') = '1';

    $fu_ok = $fu_flag in ('0', '1');
    $fu_turbo_ok = $is_turbo and $fu_flag in ('2', '3');

    return $ln_flag is null and $dl_flag is null and ($fu_ok or $fu_turbo_ok);
};

$not_gdpr = ($regionid) -> {
    $regionid = CAST($regionid as Int32);

    return case
        when Geo::IsEU($regionid) then false
        when $regionid = 84 then false
        else true
    end;
};

$not_private_relay = ($ip) -> {
    return Geo::GetIspNameByIp($ip) != "icloud private relay";
};

$seen_you = ($browserinfo) -> {
    $cy = Metrika::ParseBrowserinfo($browserinfo)["cy"];

    return case
        when $cy is null then false
        when $cy == "1" then false
        when $cy == "2" then true
        else false
    end;
};

$bestYandexuidByTs = ($uniqids) -> {
    $filtered = ListFilter($uniqids, ($x) -> { return $x is not null and $x != "0"; });

    $sorted = ListSort($filtered, ($x) -> {
        return $extract_ts($x);
    });

    return $sorted[0];
};

$max_list_values = 1000;
$is_good_list_length = ($l, $min_good, $max_good) -> {
    return ListLength($l) is not null
        and ListLength($l) > $min_good
        and ListLength($l) < $max_good;
};

$https_match = Re2::Match('^https?://.*');
