PRAGMA yt.InferSchema;
PRAGMA yt.QueryCacheMode = "normal";

{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}

insert into `{{ output_table }}` with truncate
select
    min_of(
        CAST(fpc_1 as String),
        CAST(fpc_2 as String)
    ) as u,
    max_of(
        CAST(fpc_1 as String),
        CAST(fpc_2 as String)
    ) as v,
from
    CONCAT({{ input_tables }})
where
    $is_valid_fpc(fpc_1) and
    $is_valid_fpc(fpc_2)
group by
    fpc_1, fpc_2;
