{% include 'yql/common.sql' %}
PRAGMA AnsiOrderByLimitInUnionAll;

$keyboard_uuids = (
    select
        some(`UUID`) as kuuid,
    from
        CONCAT({{ input_tables }})
    where
        (APIKey = 112684 and AppID = "ru.yandex.androidkeyboard")
        or
        (APIKey = 3295618)
    group by
        `UUID`
);

$union = (
    select
        kuuid
    from
        `{{output_table}}`
    union all select
        kuuid
    from
        $keyboard_uuids
);

insert into
    `{{output_table}}`
with truncate
select
    kuuid
from
    $union
group by
    kuuid
order by
    kuuid
;
