# this has to happen before importing luigi
from tempfile import NamedTemporaryFile

LUIGI_CONFIG = NamedTemporaryFile()
import os

os.environ["LUIGI_CONFIG_PATH"] = LUIGI_CONFIG.name

import crypta.graph.fuzzy.lib.tasks.extract  # noqa
import crypta.graph.fuzzy.lib.tasks.transform  # noqa
import crypta.graph.fuzzy.lib.tasks.evaluate  # noqa
import crypta.graph.fuzzy.lib.tasks.sources.geo  # noqa
import crypta.graph.fuzzy.lib.tasks.sources.emails  # noqa
import crypta.graph.fuzzy.lib.tasks.sources.households  # noqa
import crypta.graph.fuzzy.lib.tasks.sources.reqans  # noqa
import crypta.graph.fuzzy.lib.tasks.sources.ssid  # noqa
import crypta.graph.fuzzy.lib.tasks.sources.visitlog_logins  # noqa
import crypta.graph.fuzzy.lib.tasks.sources.heuristic  # noqa
import crypta.graph.fuzzy.lib.tasks.metrics  # noqa
import crypta.graph.fuzzy.lib.tasks.classifier  # noqa


import crypta.graph.fuzzy.lib.config as conf
from crypta.graph.fuzzy.lib.common import mkdir
import crypta.graph.fuzzy.lib.config as config
import yt.wrapper as yt

import library.python.resource as rs
from luigi.cmdline import luigi_run

import logging

logger = logging.getLogger(__name__)


def init_logger():
    logging.config.dictConfig(
        dict(
            formatters=dict(
                default=dict(format="[%(levelname)-4s][%(name)s.%(funcName)s:%(lineno)d] %(asctime)-15s: %(message)s")
            ),
            handlers=dict(console={"level": "INFO", "class": "logging.StreamHandler", "formatter": "default"}),
            root=dict(level="INFO", handlers=["console"]),
            disable_existing_loggers=False,
            version=1,
            loggers={"yt.packages.requests": {"level": "WARNING"}},
        )
    )


def prepare_environment():
    yt.config.set_proxy(config.Yt.PROXY)
    yt.config["token"] = config.Yt.TOKEN
    mkdir(yt, conf.Paths.ROOT)
    mkdir(yt, conf.Paths.metrics.METRICS_FOLDER)
    mkdir(yt, "/".join(conf.Paths.sources.ssid.DAY_TABLE.split("/")[:-1]))
    mkdir(yt, "/".join(conf.Paths.sources.ssid.CANDIDATES.split("/")[:-1]))
    mkdir(yt, conf.Paths.sources.geo.CANDIDATES)
    mkdir(yt, "/".join(conf.Paths.sources.reqans.CANDIDATES.split("/")[:-1]))
    mkdir(yt, "/".join(conf.Paths.sources.hh.CANDIDATES.split("/")[:-1]))
    mkdir(yt, conf.Paths.sources.emails.BASE)


def main():
    """
    do not forget install luigi and start luigid on 8083 port
    and dont forget "apt-get install yabs-graphite-client" for grafana
    and dont forget "apt-get install yabs-graphite-client-full" for grafana
    and create special config
    and start yabs-graphite-client
    :return:
    """
    init_logger()
    prepare_environment()
    LUIGI_CONFIG.write(rs.find("config/luigi.cfg"))
    LUIGI_CONFIG.flush()
    luigi_run()
