import datetime


def today():
    return datetime.datetime.now().date()


def tomorrow():
    return day_back(today(), -1)


def day_back(date, count):
    return date - datetime.timedelta(days=count)


def yesterday():
    return day_back(today(), 1)


def days_range(begin, end):
    assert end > begin
    count = (end - begin).days - 1
    return [day_back(end, i) for i in range(count, -1, -1)]


def days_range_back(date, count):
    return days_range(day_back(date, count), date)


def from_timestamp(ts):
    return datetime.datetime.fromtimestamp(ts).date()


def parse_day(str_):
    if str_ == "today":
        return today()
    if str_ == "yesterday":
        return yesterday()
    if str_ == "ereyesterday":
        return day_back(today(), 2)

    return datetime.datetime.strptime(str(str_), "%Y-%m-%d").date()
