import logging
from statface_client import StatfaceClient, StatfaceReportConfig
from statface_client.constants import STATFACE_PRODUCTION_UPLOAD, STATFACE_BETA
import crypta.graph.fuzzy.lib.config as conf

logger = logging.getLogger(__name__)


def to_stats_sender(report_name, data, date):
    def get_statface_upload():
        if conf.ENV_TYPE == "PRODUCTION":
            return STATFACE_PRODUCTION_UPLOAD
        return STATFACE_BETA

    client_config = {"username": conf.Stats.username, "oauth_token": conf.Stats.token, "host": get_statface_upload()}

    report_path = "Crypta/ProbabilisticMatching/{env_type}_{report_name}".format(
        env_type=conf.ENV_TYPE, report_name=report_name
    )
    logger.info("Report: %s", report_path)
    client = StatfaceClient(client_config=client_config)
    logger.info(client)

    report = client.get_report(report_path)
    values = ["- {value}: number".format(value=value) for value in data[0].keys()]
    config_in_yaml = u"""
---
dimensions:
- fielddate: date
measures:
{values}
titles:
  fielddate: Date
  metric: Metric
""".format(
        values="\n".join(values)
    )
    config = StatfaceReportConfig()
    config.from_yaml(config_in_yaml)
    config.title = u"Probability matching radius metric"
    report.upload_config(config)
    report.upload_data(scale="daily", data=[dict(record, fielddate=date) for record in data])


sender = to_stats_sender


def stat_sender(report_name, data, date):
    """
    Sends batch of metrics to local directly to yabs-graphite-sender
    via socket.

    :param report_name: report name
    :param data: field: value dict
    :param date: report date
    """
    sender(report_name, data, date)
