from yt.wrapper import yson


def create_table_with_schema(
    table, schema, compression=None, yt=None, strict=False, recreate_if_exists=True, sorted_by=None
):
    """
    this method allows to create table with scema
    allows ignore existing
    and allows sorted_by attribute in table
    """
    # TODO: too much code duplication
    if not yt:
        raise Exception("YT Wrapper (Client) not setted")

    schema = schema.copy()
    schema_attr = []

    if sorted_by:
        # sorted columns go first in schema
        for col_name in sorted_by:
            # put it to schema once
            col_type, required = schema.pop(col_name), False
            if isinstance(col_type, tuple):
                col_type, required = col_type
            col_type = col_type.lower()
            assert (col_type != "any") or (required is False)
            schema_attr.append({"name": col_name, "type": col_type, "required": required, "sort_order": "ascending"})

    for col_name, col_type in schema.items():
        if isinstance(col_type, tuple):
            col_type, required = col_type
        else:
            required = False
        col_type = col_type.lower()
        assert (col_type != "any") or (required is False)
        schema_attr.append({"name": col_name, "type": col_type, "required": required})

    schema_yson = yson.YsonList(schema_attr)
    schema_yson.attributes["strict"] = strict

    if recreate_if_exists and yt.exists(table):
        yt.remove(table, force=True)
    attributes = {"schema": schema_yson, "optimize_for": "scan"}
    if compression:
        attributes.update(compression)
    yt.create(type="table", path=table, recursive=True, attributes=attributes)


def mkdir(yt, folder):
    if folder.endswith("/"):
        folder = folder[:-1]

    if not yt.exists(folder):
        yt.mkdir(folder, True)
