import os
import pwd


def username():
    return pwd.getpwuid(os.getuid())[0]


def get_root(ENV_TYPE):
    if ENV_TYPE == "PRODUCTION":
        return "//home/crypta/production/fuzzy"
    elif ENV_TYPE == "TESTING":
        return "//home/crypta/testing/fuzzy"
    return "//home/crypta/team/{username}/fuzzy".format(username=username())


# Base paths
ENV_TYPE = os.environ.get("ENV_TYPE")
ROOT = get_root(ENV_TYPE)


CRYPTA_STATE_FOLDER = "//home/crypta/production/state"


class Yt(object):
    TOKEN = os.environ.get("YT_TOKEN")
    PROXY = os.environ.get("YT_PROXY", "hahn.yt.yandex.net")
    POOL = "crypta_graph"


class Yql(object):
    TOKEN = os.environ.get("YQL_TOKEN")
    SERVER = os.environ.get("YQL_SERVER")
    PORT = os.environ.get("YQL_PORT")
    DB = os.environ.get("YQL_DB")


class Constants(object):
    # Columns
    YUID_LEFT = "yandexuid_left"
    YUID_RIGHT = "yandexuid_right"
    CRYPTAID_LEFT = "cryptaid_left"
    CRYPTAID_RIGHT = "cryptaid_right"
    TYPE = "type"


class StatfaceReports(object):
    components_size = "Crypta/ProbabilisticMatching/Components"
    export_size = "Crypta/ProbabilisticMatching/Export"
    score_metrics = "Crypta/ProbabilisticMatching/Scores"


class Stats(object):
    username = os.environ.get("STATS_USERNAME")
    password = os.environ.get("STATS_PASSWORD")
    token = os.environ.get("STATS_TOKEN")
    reports = StatfaceReports


class SourceTypes(object):
    EMAIL_LOGIN = "EMAIL_LOGINS"
    EMAIL_SIMILAR = "EMAIL_SIMILAR"
    GEO_HOMEWORK = "GEO_HOMEWORK"
    HOUSEHOLD = "HOUSEHOLD"
    REQANS_LOG = "REQANS_LOG"
    SSID = "SSID"


class EmailPaths(object):
    ROOT = ROOT
    # Emails
    BASE = "{root}/email".format(root=ROOT)

    ALL_EMAILS_TABLE = "{base}/all_emails".format(base=BASE)
    ALL_EMAIL_LOGINS_TABLE = "{base}/all_email_logins".format(base=BASE)
    ALL_EMAILS_SORTED_BY_LOGIN = "{base}/all_email_logins.sorted_by_login".format(base=BASE)
    ALL_EMAIL_LOGINS_PAIRS_TABLE = "{base}/all_email_logins.pairs".format(base=BASE)
    ALL_EMAILS_GROUPED_BY_LOGIN = "{base}/all_email_logins.groups".format(base=BASE)
    ALL_YUID_PAIRS_FROM_EMAIL_LOGIN = "{base}/all_yuid_pairs_from_email_logins_matching".format(base=BASE)
    ALL_YUID_PAIRS_FROM_SIMILAR_EMAILS = "{base}/all_yuid_pairs_from_similar_emails".format(base=BASE)

    ALL_EMAILS_TABLE_SCHEMA = {"email": "string", "yuids": "any"}
    ALL_EMAIL_LOGINS_TABLE_SCHEMA = {"login": "string", "email": "string", "yuids": "any"}
    ALL_EMAILS_SORTED_BY_LOGIN_SCHEMA = {"login": "string", "email": "string", "yuids": "any"}
    ALL_EMAILS_GROUPED_BY_LOGIN_SCHEMA = {"login": "string", "all_emails": "any", "howmany": "uint64"}
    ALL_EMAIL_LOGINS_PAIRS_TABLE_SCHEMA = {
        "email_1": "string",
        "email_2": "string",
        "login": "string",
        "yuids_1": "any",
        "yuids_2": "any",
    }
    ALL_YUID_PAIRS_FROM_EMAIL_LOGIN_SCHEMA = {
        Constants.YUID_LEFT: ("uint64", True),
        Constants.YUID_RIGHT: ("uint64", True),
        "match": "any",
    }
    ALL_YUID_PAIRS_FROM_SIMILAR_EMAILS_SCHEMA = {
        Constants.YUID_LEFT: "uint64",
        Constants.YUID_RIGHT: "uint64",
        "email_left": "string",
        "email_right": "string",
        "fragment": "string",
    }


class GeoPaths(object):
    ROOT = ROOT
    # Geo
    HOMEWORK_DIR = "//home/user_identification/homework/prod/state"
    CANDIDATES = "{root}/geo".format(root=ROOT)
    CANDIDATES_SCHEMA = {Constants.YUID_LEFT: "uint64", Constants.YUID_RIGHT: "uint64", "distance": "double"}


class HhPaths(object):
    ROOT = ROOT
    # Households
    MERGED_HOUSEHOLDS = "{state}/household2/merged_hh".format(state=CRYPTA_STATE_FOLDER)
    CANDIDATES = "{root}/hh/households_candidates".format(root=ROOT)
    CANDIDATES_SCHEMA = {Constants.YUID_LEFT: "uint64", Constants.YUID_RIGHT: "uint64", "hh": "uint64"}


class ReqansPaths(object):
    ROOT = ROOT
    # Reqans
    REQANS_LOGS = "//logs/reqans-log/1d/{date}"
    REQANS_MAP_LOGS = "//logs/map-reqans-log/1d/{date}"
    DAY_CANDIDATES = "{root}/reqans/{{date}}".format(root=ROOT)
    CANDIDATES = "{root}/reqans/candidates".format(root=ROOT)
    CANDIDATES_SCHEMA = {
        Constants.YUID_LEFT: "uint64",
        Constants.YUID_RIGHT: "uint64",
        "intersected_queries": "uint64",
        "queries": "any",
    }


class VisitLogPaths(object):
    ROOT = "//logs/visit-v2-log"
    DAY_LOG = "{root}/1d/{{date}}".format(root=ROOT)


class LoginPaths(object):
    ROOT = "{root}/login".format(root=ROOT)
    DAY_LOGINS = "{root}/{{date}}".format(root=ROOT)
    DAY_LOGINS_SCHEMA = {"host": "string", "keyword": "string", "login": "string", "yandexuid": "uint64"}
    CANDIDATES = "{root}/candidates".format(root=ROOT)
    CANDIDATES_SCHEMA = {
        "yandexuid_left": "uint64",
        "yandexuid_right": "uint64",
        "matched": "string",
        "matched_hosts": "uint32",
    }


class SsidPaths(object):
    ROOT = ROOT
    # Ssid from mobile metrika
    MM_DAY_TABLE = "//logs/metrika-mobile-log/1d/{date}"
    DAY_TABLE = "{root}/ssid/mobile_metrika_day_{{date}}".format(root=ROOT)
    DAY_TABLE_SCHEMA = {"mmetric_devid": "string", "ssid": "string"}
    CANDIDATES = "{root}/ssid/mobile_metrika_ssid_candidates".format(root=ROOT)
    CANDIDATES_SCHEMA = {Constants.YUID_LEFT: "uint64", Constants.YUID_RIGHT: "uint64", "ssid": "any"}


class HeuristicPaths(object):
    ROOT = "{root}/exact".format(root=ROOT)
    SOURCE = "//home/crypta/production/state/graph/dicts/exact_yuid_cid"
    PAIRS = "{root}/pairs".format(root=ROOT)
    PAIRS_SCHEMA = {Constants.YUID_LEFT: "uint64", Constants.YUID_RIGHT: "uint64"}


class SourcesPaths:
    ROOT = ROOT
    emails = EmailPaths
    geo = GeoPaths
    hh = HhPaths
    reqans = ReqansPaths
    ssid = SsidPaths
    logins = LoginPaths
    heuristic = HeuristicPaths


class MetricsPaths(object):
    ROOT = ROOT
    METRICS_FOLDER = "{root}/metrics".format(root=ROOT)

    REPORTS = "{metrics}/reports".format(metrics=METRICS_FOLDER)

    EXACT_MATCHING_PROOF_METRICS_TABLE = "{metrics}/exact_matching_proof".format(metrics=METRICS_FOLDER)
    EXACT_MATCHING_PROOF_METRICS_TABLE_SCHEMA = {"unit": "string", "amount": "uint64", "date": "string"}

    OLD_FUZZY_MATCHING_PROOF_METRICS_TABLE = "{metrics}/old_fuzzy_matching_proof".format(metrics=METRICS_FOLDER)
    OLD_FUZZY_MATCHING_PROOF_METRICS_TABLE_SCHEMA = {"unit": "string", "amount": "uint64", "date": "string"}

    GROUPPED_YUIDS_TABLE = "{base}/yuids_by_new_cryptaids".format(base=ROOT)
    EXACT_GROUPPED_YUIDS_TABLE = "{base}/exact_yuids_by_new_cryptaids".format(base=ROOT)
    FUZZY_GROUPPED_YUIDS_TABLE = "{base}/fuzzy_yuids_by_new_cryptaids".format(base=ROOT)
    GROUPPED_YUIDS_TABLE_SCHEMA = {"cryptaId": "string", "id": "string", "id_type": "string"}

    ONLY_FUZZY_METRICS_TABLE = "{metrics}/only_fuzzy_raduis_metrics_table".format(metrics=METRICS_FOLDER)
    FUZZY_EXACT_RADIUS_METRICS_TABLE = "{metrics}/fuzzy_exact_raduis_metrics_table".format(metrics=METRICS_FOLDER)
    FUZZY_OLDFUZZY_RADIUS_METRICS_TABLE = "{metrics}/fuzzy_oldfuzzy_raduis_metrics_table".format(
        metrics=METRICS_FOLDER
    )
    EXACT_RADIUS_METRICS_TABLE = "{metrics}/exact_raduis_metrics_table".format(metrics=METRICS_FOLDER)
    OLD_FUZZY_RADIUS_METRICS_TABLE = "{metrics}/old_fuzzy_raduis_metrics_table".format(metrics=METRICS_FOLDER)
    MDMATCHING_METRICS_TABLE = "{metrics}/mobile_desktop_matching_table".format(metrics=METRICS_FOLDER)
    RADIUS_METRICS_TABLE_SCHEMA = {"unit": "string", "amount": "double", "date": "string", "reverse_date": "int64"}


def get_graph_path():
    if ENV_TYPE == "PRODUCTION":
        graph_path_boilerplate = "production"
    elif ENV_TYPE == "TESTING":
        graph_path_boilerplate = "testing"
    else:
        return None
    return "//home/crypta/{graph_path_boilerplate}".format(graph_path_boilerplate=graph_path_boilerplate)


class Paths(object):
    ROOT = ROOT
    sources = SourcesPaths
    metrics = MetricsPaths

    CRYPTA_STATE_FOLDER = CRYPTA_STATE_FOLDER
    CRYPTA_METRICS_DAY_FOLDER = "{state}/radius/metrics/{{date}}".format(state=CRYPTA_STATE_FOLDER)
    CRYPTA_RLOGIN_TABLE = "{base}/yuid_rlogin/yuid_rlogin_final_stable".format(base=CRYPTA_METRICS_DAY_FOLDER)
    CRYPTA_DICTS = "{state}/graph/dicts".format(state=CRYPTA_STATE_FOLDER)
    YUID_WITH_EMAIL = "{base}/yuid_with_id_email".format(base=CRYPTA_DICTS)
    YUID_WITH_ALL = "{base}/yuid_with_all".format(base=CRYPTA_DICTS)
    MOB_YUIDS_RUS = "{state}/graph/{{date}}/stat_new/all/mob_yuids_rus".format(state=CRYPTA_STATE_FOLDER)
    INDEVICE_PERFECT_NO_LIMIT = "{base}/dev_yuid_indevice_perfect_no_limit".format(base=CRYPTA_DICTS)
    EXACT_MATCING_BY_KEY = "{base}/matching/exact_vertices_by_key".format(base=CRYPTA_DICTS)
    EXACT_MATCING_BY_CRYPTAID = "{base}/matching/exact_vertices_by_crypta_id".format(base=CRYPTA_DICTS)
    OLD_FUZZY_MATCING_BY_KEY = "{base}/matching/fuzzy_vertices_by_key".format(base=CRYPTA_DICTS)

    COLLECTED_DATA = "{base}/yuid_all_collected_pairs".format(base=ROOT)
    COLLECTED_DATA_SCHEMA = {
        Constants.YUID_LEFT: "uint64",
        Constants.YUID_RIGHT: "uint64",
        "type": "string",
        "attributes": "any",
    }

    COLLECTED_YUID_PAIRS = "{base}/uniq_yuid_pairs".format(base=ROOT)
    COLLECTED_YUID_PAIRS_SCHEMA = {Constants.YUID_LEFT: "uint64", Constants.YUID_RIGHT: "uint64"}

    ENRICHED_PAIRS = "{base}/enriched_pairs".format(base=ROOT)
    ENRICHED_PAIRS_SCHEMA = {
        Constants.YUID_LEFT: "uint64",
        Constants.YUID_RIGHT: "uint64",
        "type": "string",
        "socdem_left_gender": "any",
        "socdem_left_age_segments": "any",
        "socdem_left_income_segments": "any",
        "socdem_right_gender": "any",
        "socdem_right_age_segments": "any",
        "socdem_right_income_segments": "any",
    }

    GLOBAL_COUNTERS = "{base}/global_counters".format(base=ROOT)
    CONDITIONAL_COUNTERS = "{base}/conditional_counters".format(base=ROOT)
    FUZZY_CANDIDATES = "{base}/fuzzy_candidates".format(base=ROOT)

    FUZZY_RESULT = "{base}/yuid_pairs_result".format(base=ROOT)
    FUZZY_RESULT_SCHEMA = {Constants.YUID_LEFT: "uint64", Constants.YUID_RIGHT: "uint64", "score": "double"}
    DEBUG_BAYES_TABLE = "{base}/bayes_table".format(base=ROOT)
    DEBUG_SCORES = "{base}/bayes_scores".format(base=ROOT)
    FUZZY_MATCHING = "{base}/matching".format(base=ROOT)

    EXPORT_SUP = "{graph_path}/state/graph/v2/soup" "/yandexuid_yandexuid_fuzzy_bayes".format(
        graph_path=get_graph_path()
    )

    EXPORT_EXTERNAL_SCHEMA = {
        "id_type": ("string", True),
        "id_value": ("double", True),
        "key": ("string", True),
        "pair_source": ("string", True),
        "pair_type": ("string", True),
        "yuid1_source": ("any", False),
        "yuid2_source": ("any", False),
    }
    EXPORT_EXTERNAL = "{graph_path}/state/prob-match/fuzzy_pairs_new".format(graph_path=get_graph_path())
