from crypta.graph.fuzzy.lib.luiger import BaseTask, DateParameter
from crypta.graph.fuzzy.lib.tasks.classifier.collect import requires_tasks_dict
from crypta.graph.fuzzy.lib.common import cached_property
import crypta.graph.fuzzy.lib.config as conf
import logging

logger = logging.getLogger(__name__)


class ComputeCounters(BaseTask):

    date = DateParameter()

    @cached_property
    def requirements(self):
        return {name: task(date=self.date) for name, task in requires_tasks_dict.iteritems()}

    def requires(self):
        for requirement in self.requirements.values():
            yield requirement

    def output(self):
        yield self.yt.targets.table_is_actual(self.conditional_counters, self.date.isoformat())
        yield self.yt.targets.table_is_actual(self.global_counters, self.date.isoformat())
        yield self.yt.targets.table_is_actual(self.candidates, self.date.isoformat())
        yield self.yt.targets.table_is_actual(conf.Paths.DEBUG_SCORES, self.date.isoformat())

    @property
    def candidates(self):
        return conf.Paths.FUZZY_CANDIDATES

    @property
    def global_counters(self):
        return conf.Paths.GLOBAL_COUNTERS

    @property
    def conditional_counters(self):
        return conf.Paths.CONDITIONAL_COUNTERS

    @property
    def query(self):
        params = {
            "name": "yql/bayes_table",
            "bayes_table": conf.Paths.DEBUG_BAYES_TABLE,
            "yuid_with_all": conf.Paths.YUID_WITH_ALL,
            "candidates": self.candidates,
            "debug_scores": conf.Paths.DEBUG_SCORES,
            "global_counters": self.global_counters,
            "conditional_counters": self.conditional_counters,
        }
        for name, task in self.requirements.iteritems():
            params[name] = task.destination
        logger.info("Query params: %s", params)
        return self.render_resource(**params)

    def _run(self):
        self.yql.execute(self.query)
        self.yt.set(conf.Paths.DEBUG_SCORES + "/@generate_date", self.date.isoformat())
        self.yt.set(self.conditional_counters + "/@generate_date", self.date.isoformat())
        self.yt.set(self.global_counters + "/@generate_date", self.date.isoformat())
        self.yt.set(self.candidates + "/@generate_date", self.date.isoformat())
