from crypta.graph.fuzzy.lib.luiger import BaseTask, DateParameter
from crypta.graph.fuzzy.lib.tasks.classifier.collect import CollectTask
import crypta.graph.fuzzy.lib.config as conf


class EnrichTask(BaseTask):
    date = DateParameter()

    def requires(self):
        return CollectTask(date=self.date)

    @property
    def source(self):
        return self.requires().destination

    @property
    def destination(self):
        return conf.Paths.ENRICHED_PAIRS

    def output(self):
        return self.yt.targets.table_is_actual(self.destination, self.date.isoformat())

    def _run(self):
        query = self.render_resource(
            "yql/yuid_enricher",
            source=self.yql.path(self.source),
            destination=self.yql.path(self.destination),
            source_yuid_with_all=self.yql.path(conf.Paths.YUID_WITH_ALL),
        )
        self.yql.execute(query)

        self.yt.set(self.destination + "/@generate_date", self.date.isoformat())
