from crypta.graph.fuzzy.lib.luiger import BaseTask, DateParameter, WrapperTask
from crypta.graph.fuzzy.lib.common.dates import yesterday
import logging
import crypta.graph.fuzzy.lib.config as conf

logger = logging.getLogger(__name__)


class ExtractBsWatchLog(BaseTask):

    date = DateParameter()

    def _run(self):
        query = self.render_resource(
            "yql/bs_watch_log", source=self.yql.path(self.source), destination=self.yql.path(self.destination)
        )
        self.yql.execute(query, syntax_version=1)

    @property
    def source(self):
        return self.yt.path("//home/logfeller/logs").join("bs-watch-log").join("1d").join(self.date.isoformat())

    @property
    def destination(self):
        return "{root}/{date}".format(root=conf.Paths.ROOT, date=self.date)

    def output(self):
        yield self.yt.targets.not_empty(self.destination)


class Extract(WrapperTask):
    def requires(self):
        yield ExtractBsWatchLog(date=yesterday())
