import logging
import crypta.graph.fuzzy.lib.config as conf
from crypta.graph.fuzzy.lib.tasks.metrics.connected_components import MatchConnectedComponents
from crypta.graph.fuzzy.lib.luiger import DateParameter
from crypta.graph.fuzzy.lib.common import cached_property
from statface import StatfaceReportTask

logger = logging.getLogger(__name__)


class FuzzyComponentsSize(StatfaceReportTask):

    date = DateParameter()

    @property
    def destination(self):
        return conf.Paths.metrics.REPORTS

    @property
    def report_path(self):
        return conf.Stats.reports.components_size

    @property
    def attribute(self):
        return self.__class__.__name__

    @cached_property
    def _connected_components(self):
        return MatchConnectedComponents(date=self.date)

    def requires(self):
        yield self._connected_components

    def output(self):
        return [self.yt.targets.table_is_actual(self.destination, self.date.isoformat(), self.attribute)]

    def _send_report(self, data):
        table = data[0]
        metrics = dict(zip(table.column_names, table.rows[0]))
        metrics["fielddate"] = self.date.isoformat()
        self._report.upload_data(scale="daily", data=[metrics])

    @cached_property
    def query(self):
        return self.render_resource(name="yql/components_size", matching=self._connected_components.destination)

    def _run(self):
        result_sets = self.yql.execute(self.query)
        self._send_report(result_sets)
        self.yt.set("{path}/@{attr}".format(path=self.destination, attr=self.attribute), self.date.isoformat())
