import logging
from crypta.graph.mrcc.lib import MRConnectedComponentsYT
import crypta.graph.fuzzy.lib.config as conf
from crypta.graph.fuzzy.lib.tasks.classifier.export import ExportAll


logger = logging.getLogger(__name__)


class MatchConnectedComponents(ExportAll):
    @property
    def destination(self):
        return conf.Paths.FUZZY_MATCHING

    def requires(self):
        yield self._classifier

    def output(self):
        return [self.yt.targets.table_is_actual(self.destination, self.date.isoformat())]

    def get_preprocessing_query(self, graph):
        return self.render_resource(
            name="yql/components_preprocessing",
            source=self._classifier.destination,
            destination=graph,
            threshold=self.threshold,
        )

    def get_postprocessing_query(self, graph):
        return self.render_resource(name="yql/components_postprocessing", graph=graph, destination=self.destination)

    def _run(self):
        with self.yt.TempTable() as graph:
            self.yql.execute(self.get_preprocessing_query(graph))
            mrcc_job = MRConnectedComponentsYT(self.yt)
            converged = mrcc_job.find_connected_components(graph)
            if not converged:
                raise RuntimeError("MRCC doesn't converge")
            self.yql.execute(self.get_postprocessing_query(graph))
        self.yt.set(self.destination + "/@threshold", self.threshold)
        self.yt.set(self.destination + "/@generate_date", self.date.isoformat())
