import logging
import crypta.graph.fuzzy.lib.config as conf
from crypta.graph.fuzzy.lib.luiger import DateParameter
from crypta.graph.fuzzy.lib.common import cached_property
from crypta.graph.fuzzy.lib.tasks.classifier import ExportExternalSystems, get_threshold
from statface import StatfaceReportTask

logger = logging.getLogger(__name__)


class ExportSize(StatfaceReportTask):

    date = DateParameter()

    @property
    def destination(self):
        return conf.Paths.metrics.REPORTS

    @property
    def report_path(self):
        return conf.Stats.reports.export_size

    @property
    def attribute(self):
        return self.__class__.__name__

    @cached_property
    def _export_external(self):
        threshold = get_threshold(self.yt)
        return ExportExternalSystems(date=self.date, threshold=threshold)

    def requires(self):
        yield self._export_external

    def output(self):
        return [self.yt.targets.table_is_actual(self.destination, self.date.isoformat(), self.attribute)]

    def _send_report(self, export_size):
        self._report.upload_data(scale="daily", data=[{"fielddate": self.date.isoformat(), "edges": export_size}])

    def _run(self):
        export_size = self.yt.get("{table}/@row_count".format(table=self._export_external.destination))
        self._send_report(export_size)
        self.yt.set("{path}/@{attr}".format(path=self.destination, attr=self.attribute), self.date.isoformat())
