import logging
import crypta.graph.fuzzy.lib.config as conf
from crypta.graph.fuzzy.lib.luiger import DateParameter
from crypta.graph.fuzzy.lib.common import cached_property
from crypta.graph.fuzzy.lib.tasks.classifier import BayesClassifyTask, get_threshold
from statface import StatfaceReportTask

logger = logging.getLogger(__name__)


class ScoreMetrics(StatfaceReportTask):

    date = DateParameter()

    @property
    def destination(self):
        return conf.Paths.metrics.REPORTS

    @property
    def report_path(self):
        return conf.Stats.reports.score_metrics

    @property
    def attribute(self):
        return self.__class__.__name__

    @cached_property
    def _classifier(self):
        return BayesClassifyTask(date=self.date)

    def requires(self):
        yield self._classifier

    def output(self):
        return [self.yt.targets.table_is_actual(self.destination, self.date.isoformat(), self.attribute)]

    def _send_report(self, data):
        table = data[0]
        table.fetch_full_data()
        metrics = []
        for row in table.rows:
            metric = dict(zip(table.column_names, row))
            metric["fielddate"] = self.date.isoformat()
            metrics.append(metric)
        logger.info(metrics)
        self._report.upload_data(scale="daily", data=metrics)

    @cached_property
    def query(self):
        threshold = get_threshold(self.yt)
        return self.render_resource(
            name="yql/score_metrics",
            fuzzy_candidates=conf.Paths.FUZZY_CANDIDATES,
            bayes_scores=conf.Paths.DEBUG_SCORES,
            threshold=threshold,
        )

    def _run(self):
        result_sets = self.yql.execute(self.query)
        self._send_report(result_sets)
        self.yt.set("{path}/@{attr}".format(path=self.destination, attr=self.attribute), self.date.isoformat())
