from crypta.graph.fuzzy.lib.luiger import BaseTask
from crypta.graph.fuzzy.lib.common import cached_property
import crypta.graph.fuzzy.lib.config as conf
import six
import abc
from statface_client.constants import STATFACE_PRODUCTION_UPLOAD, STATFACE_BETA
from statface_client import StatfaceClient


@six.add_metaclass(abc.ABCMeta)
class StatfaceReportTask(BaseTask):
    @abc.abstractproperty
    def report_path(self):
        pass

    @cached_property
    def __statface_config(self):
        def get_statface_upload():
            if conf.ENV_TYPE == "PRODUCTION":
                return STATFACE_PRODUCTION_UPLOAD
            return STATFACE_BETA

        client_config = {
            "username": conf.Stats.username,
            "oauth_token": conf.Stats.token,
            "host": get_statface_upload(),
        }
        return client_config

    @cached_property
    def _statface_client(self):
        return StatfaceClient(client_config=self.__statface_config)

    @property
    def _report(self):
        return self._statface_client.get_old_report(self.report_path)

    @abc.abstractmethod
    def _send_report(self, data):
        pass
