"""
Module to take all email yuids pairs
"""
from crypta.graph.fuzzy.lib.luiger import DateParameter, BaseTask
from additional_utils import norm_email
from yt.wrapper import with_context as yt_with_context, common as yt_common, create_table_switch

import crypta.graph.fuzzy.lib.config as conf


def check_email_by_white_mapper(record):
    """
    here we check email is corrected
    """
    email = norm_email(record.get("id_value", ""))
    if email:
        yield {"id_value": email, "yandexuid": record["yandexuid"]}


@yt_with_context
def take_one_rec_reducer(keys, records, context):
    """
    take only one record
    """
    yuids = []
    for rec in records:
        yuids.append(rec["yandexuid"])
    if keys["id_value"] and len(yuids) < 200:
        yield create_table_switch(0)
        yield {"email": keys["id_value"], "yuids": sorted(yuids)}
        yield create_table_switch(1)
        yield {"login": keys["id_value"].split("@")[0], "email": keys["id_value"], "yuids": sorted(yuids)}


class ExtractAllEmailsAndLoginsTask(BaseTask):
    """
    This luigi task take all emails and build tables
    where this emails grouped by crypta_id
    """

    date = DateParameter()

    def output(self):
        """
        result of this task
        """
        return [
            self.yt.targets.table_is_actual(conf.Paths.sources.emails.ALL_EMAILS_TABLE, self.date.isoformat()),
            self.yt.targets.table_is_actual(conf.Paths.sources.emails.ALL_EMAIL_LOGINS_TABLE, self.date.isoformat()),
        ]

    def _run(self):
        """
        In this method we take yuid_with_id_email and take all email-[yuids]
        pairs
        """
        self.yt.create_table_with_schema(
            conf.Paths.sources.emails.ALL_EMAILS_TABLE,
            conf.Paths.sources.emails.ALL_EMAILS_TABLE_SCHEMA,
            strict=True,
            recreate_if_exists=True,
        )

        self.yt.create_table_with_schema(
            conf.Paths.sources.emails.ALL_EMAIL_LOGINS_TABLE,
            conf.Paths.sources.emails.ALL_EMAIL_LOGINS_TABLE_SCHEMA,
            strict=True,
            recreate_if_exists=True,
        )

        self.yt.run_map_reduce(
            check_email_by_white_mapper,
            take_one_rec_reducer,
            conf.Paths.YUID_WITH_EMAIL,
            [conf.Paths.sources.emails.ALL_EMAILS_TABLE, conf.Paths.sources.emails.ALL_EMAIL_LOGINS_TABLE],
            reduce_by=["id_value"],
            spec={"data_size_per_map_job": 128 * yt_common.MB},
        )

        self.yt.set(conf.Paths.sources.emails.ALL_EMAILS_TABLE + "/@generate_date", self.date.isoformat())
        self.yt.set(conf.Paths.sources.emails.ALL_EMAIL_LOGINS_TABLE + "/@generate_date", self.date.isoformat())
