#pragma once

#include <util/system/types.h>

namespace NFuzzyGeo {
    struct TPoint {
        double Lat;
        double Lon;
    };

    struct TSquare {
        ui32 Belt;
        ui32 Sq;
    };

    // https://en.wikipedia.org/wiki/Latitude#Authalic_latitude
    static constexpr double EARTH_RADIUS = 6371007.2;

    double computeDistance(const TPoint& src, const TPoint& dst);
    TSquare computeSquare(const TPoint& p, double sideSz);

    ui64 ConvertSquareToIdx(const TSquare &square);
    TSquare ConvertIdxToSquare(ui64 squareIdx);
};
