from crypta.graph.fuzzy.lib.luiger import BaseTask, DateParameter
from crypta.lib.python.native_yt import run_native_reduce
import crypta.graph.fuzzy.lib.config as conf
import native_operations  # noqa


class ExtractExactPairs(BaseTask):

    date = DateParameter()

    @property
    def source(self):
        return conf.Paths.sources.heuristic.SOURCE

    @property
    def destination(self):
        return conf.Paths.sources.heuristic.PAIRS

    @property
    def destination_schema(self):
        return conf.Paths.sources.heuristic.PAIRS_SCHEMA

    def output(self):
        yield self.yt.targets.table_is_actual(self.destination, self.date.isoformat())

    def _run(self):
        if self.yt.exists(self.destination):
            self.yt.remove(self.destination)
        self.yt.create_table_with_schema(
            self.destination, self.destination_schema, strict=True, recreate_if_exists=False
        )
        with self.yt.TempTable() as sorted_source:
            self.yt.run_sort(self.source, sorted_source, sort_by=["cid"])
            run_native_reduce(
                reducer_name="NExactMatching::TExplode",
                source=sorted_source,
                destination=self.destination,
                proxy=self.yt.proxy,
                transaction=self.yt.transaction_id,
                pool=conf.Yt.POOL,
                title="Produce exact matching pairs",
                reduce_by=["cid"],
            )
        self.yt.run_sort(self.destination, sort_by=[conf.Constants.YUID_LEFT, conf.Constants.YUID_RIGHT])
        self.yt.set(self.destination + "/@generate_date", self.date.isoformat())
