#pragma once

#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <crypta/lib/python/native_yt/cpp/proto.h>
#include <util/generic/set.h>
#include <util/stream/str.h>
#include <util/string/cast.h>

using NYT::TNode;
using NYT::IReducer;
using NYT::TTableReader;
using NYT::TTableWriter;

namespace NExactMatching {

    const TString YUID = "yuid";
    const TString YANDEXUID_LEFT = "yandexuid_left";
    const TString YANDEXUID_RIGHT = "yandexuid_right";

    class TExplode: public IReducer<TTableReader<TNode>, TTableWriter<TNode>> {
    public:
        void Do(TReader* input, TWriter* output) override {
            TSet<ui64> yandexuids;
            for (; input->IsValid(); input->Next()) {
                const auto& row = input->GetRow();
                try {
                    ui64 yandexuid = FromString<ui64>(row[YUID].AsString());
                    yandexuids.insert(yandexuid);
                } catch(TFromStringException exc) {
                    continue;
                }
            }
            for (auto i = yandexuids.begin(); i != yandexuids.end(); ++i) {
                for (auto j = i; ++j != yandexuids.end();) {
                    ui64 yandexuid_left = Min(*i, *j);
                    ui64 yandexuid_right = Max(*i, *j);
                    TNode out;
                    out(YANDEXUID_LEFT, yandexuid_left);
                    out(YANDEXUID_RIGHT, yandexuid_right);
                    output->AddRow(out);
                }
            }
        }
    };
}

CYT_REGISTER_REDUCER(NExactMatching::TExplode);
