from crypta.graph.fuzzy.lib.luiger import DateParameter, BaseTask
from crypta.graph.fuzzy.lib.common import cached_property
import datetime
import crypta.graph.fuzzy.lib.config as conf


class WaitForSource(BaseTask):

    date = DateParameter()

    def output(self):
        return [self.yt.targets.table_is_actual(conf.Paths.sources.hh.MERGED_HOUSEHOLDS, self.date.isoformat())]

    def _run(self):
        pass


class ImportHouseHoldsTask(BaseTask):

    date = DateParameter()

    def requires(self):
        dt = self.date - datetime.timedelta(days=1)
        return [WaitForSource(date=dt)]

    @property
    def source_type(self):
        return conf.SourceTypes.HOUSEHOLD

    @property
    def source(self):
        return conf.Paths.sources.hh.MERGED_HOUSEHOLDS

    @property
    def destination(self):
        return conf.Paths.sources.hh.CANDIDATES

    @property
    def destination_schema(self):
        return conf.Paths.sources.hh.CANDIDATES_SCHEMA

    @cached_property
    def query(self):
        return self.render_resource(
            "yql/export_hh", households=self.yql.path(self.source), destination=self.yql.path(self.destination)
        )

    def output(self):
        """
        result of this task
        """
        return [self.yt.targets.table_is_actual(self.destination, self.date.isoformat())]

    def _run(self):
        """
        In this method we extract all households to candidate pairs
        """
        print("!!! Import run")
        self.yt.create_table_with_schema(
            self.destination, self.destination_schema, strict=True, recreate_if_exists=True
        )
        self.yql.execute(self.query)
        self.yt.run_sort(self.destination, sort_by=[conf.Constants.YUID_LEFT, conf.Constants.YUID_RIGHT])
        self.yt.set(self.destination + "/@generate_date", self.date.isoformat())
