from crypta.graph.fuzzy.lib.luiger import DateParameter, IntParameter, BaseTask
from crypta.graph.fuzzy.lib.common import cached_property

import crypta.graph.fuzzy.lib.config as conf


class ImportReqansLogTask(BaseTask):

    date = DateParameter()
    yandexuid_threshold = IntParameter(default=10)

    @property
    def reqans(self):
        return conf.SourcesPaths.reqans.REQANS_LOGS.format(date=self.date.isoformat())

    @property
    def reqans_map(self):
        return conf.SourcesPaths.reqans.REQANS_MAP_LOGS.format(date=self.date.isoformat())

    @property
    def destination(self):
        return conf.Paths.sources.reqans.CANDIDATES

    @property
    def destination_schema(self):
        return conf.Paths.sources.reqans.CANDIDATES_SCHEMA

    def output(self):
        """
        result of this task
        """
        return [self.yt.targets.table_is_actual(self.destination, self.date.isoformat())]

    @cached_property
    def query(self):
        return self.render_resource(
            "yql/reqans",
            reqans_map=self.reqans_map,
            reqans=self.reqans,
            destination=self.yql.path(self.destination),
            yandexuid_threshold=self.yandexuid_threshold,
        )

    def _run(self):
        self.yt.create_table_with_schema(
            self.destination, self.destination_schema, strict=True, recreate_if_exists=True
        )
        self.yql.execute(self.query)
        self.yt.set(self.destination + "/@generate_date", self.date.isoformat())
