"""
Module to take all email yuids pairs
"""
from crypta.graph.fuzzy.lib.luiger import DateParameter, IntParameter, BaseTask
from crypta.graph.fuzzy.lib.common import cached_property
import crypta.graph.fuzzy.lib.config as conf


class ImportSsidMobileMetrikaDayTask(BaseTask):
    """
    This luigi task take all emails and build tables
    where this emails grouped by crypta_id
    """

    date = DateParameter()
    target_date = DateParameter()
    ssid_threshold = IntParameter()

    @cached_property
    def source_type(self):
        return conf.SourceTypes.SSID

    @cached_property
    def source(self):
        return conf.Paths.sources.ssid.MM_DAY_TABLE.format(date=self.target_date.isoformat())

    @cached_property
    def destination(self):
        return conf.Paths.sources.ssid.DAY_TABLE.format(date=self.target_date.isoformat())

    @cached_property
    def destination_schema(self):
        return conf.Paths.sources.ssid.DAY_TABLE_SCHEMA

    def output(self):
        """
        result of this task
        """
        return [self.yt.targets.exists(self.destination)]

    @cached_property
    def query(self):
        return self.render_resource(
            "yql/export_ssid_devid_day_table",
            source_mmetric_table=self.yql.path(self.source),
            destination=self.yql.path(self.destination),
            ssid_threshold=self.ssid_threshold,
        )

    def _run(self):
        """
        In this method we extract all households to candidate pairs
        """
        self.yt.create_table_with_schema(
            self.destination, self.destination_schema, strict=True, recreate_if_exists=True
        )

        self.yql.execute(self.query, syntax_version=1)

        self.yt.set(self.destination + "/@generate_date", self.date.isoformat())
