#pragma once

#include <crypta/lib/python/native_yt/cpp/registrar.h>
#include <crypta/lib/python/native_yt/cpp/proto.h>
#include <crypta/graph/fuzzy/lib/tasks/sources/proto/ssid_messages.pb.h>
#include <util/stream/str.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/generic/set.h>
#include <util/generic/maybe.h>
#include <util/string/vector.h>
using NYT::TNode;
using NYT::IReducer;
using NYT::TTableReader;
using NYT::TTableWriter;

namespace NCommonWifiAP {
    const TString YANDEXUID = "yandexuid";
    const TString DEVID = "devid";
    const TString SSID = "ssid";
    const TString YANDEXUID_LEFT = "yandexuid_left";
    const TString YANDEXUID_RIGHT = "yandexuid_right";

    class TExploder: public IReducer<TTableReader<TNode>, TTableWriter<TNode>> {
    public:
        using TDeviceYandexuids = TVector<ui64>;
        using TWifiYandexuids = THashMap<TString, TDeviceYandexuids>;

        void Do(TReader* input, TWriter* output) override {
            TWifiYandexuids yandexuids;
            TMaybe<TString> ssid;
            for (; input->IsValid(); input->Next()) {
                const auto& row = input->GetRow();
                if (not ssid.Defined()) {
                    ssid = row[SSID].AsString();
                }
                yandexuids[row[DEVID].AsString()].push_back(row[YANDEXUID].AsUint64());
            }
            Yield(output, *ssid, yandexuids);
        }

    private:
        void Yield(TTableWriter<TNode>* output, const TString& ssid, const TWifiYandexuids& yandexuids) {
            for (auto i = yandexuids.begin(); i != yandexuids.end(); ++i) {
                const auto& devidI = i->first;
                const auto& yandexuidListI = i->second;
                for (auto j = yandexuids.begin(); j != yandexuids.end(); ++j) {
                    const auto& devidJ = j->first;
                    const auto& yandexuidListJ = j->second;
                    if (devidI == devidJ) {
                        continue;
                    }
                    YieldLists(output, ssid, yandexuidListI, yandexuidListJ);
                }
            }
        }

        void YieldLists(TTableWriter<TNode>* output, const TString& ssid, const TDeviceYandexuids& listI, const TDeviceYandexuids& listJ) {
            for (const auto yandexuidI : listI) {
                for (const auto yandexuidJ : listJ) {
                    if (yandexuidI == yandexuidJ) {
                        continue;
                    }
                    ui64 yandexuid_left = Min(yandexuidI, yandexuidJ);
                    ui64 yandexuid_right = Max(yandexuidI, yandexuidJ);
                    TNode out;
                    out(SSID, ssid);
                    out(YANDEXUID_LEFT, yandexuid_left);
                    out(YANDEXUID_RIGHT, yandexuid_right);
                    output->AddRow(out);
                }
            }
        }
    };

    class TUnique: public IReducer<TTableReader<TNode>, TTableWriter<TNode>> {
        void Do(TReader* input, TWriter* output) override {
            TSet<TString> ssids;
            bool is_firstRow = true;
            TNode out;
            for (; input->IsValid(); input->Next()) {
                const auto& row = input->GetRow();
                ssids.insert(row[SSID].AsString());
                if (is_firstRow) {
                    is_firstRow = false;
                    out(YANDEXUID_LEFT, row[YANDEXUID_LEFT].AsUint64());
                    out(YANDEXUID_RIGHT, row[YANDEXUID_RIGHT].AsUint64());
                }
            }
            TNode macs = TNode::CreateList();
            for (const auto& mac : ssids) {
                macs.Add(mac);
            }
            out(SSID, macs);
            output->AddRow(out);
        }
    };
};

CYT_REGISTER_REDUCER(NCommonWifiAP::TExploder);
CYT_REGISTER_REDUCER(NCommonWifiAP::TUnique);
