PY2_LIBRARY()

OWNER(g:crypta)

PEERDIR(
    contrib/python/luigi
    yt/python/client
    library/python/resource
    library/cpp/uri
    library/cpp/json
    contrib/libs/re2
    library/python/statface_client
    crypta/lib/python/yql/client
    crypta/lib/python/native_yt/cpp
    crypta/graph/lib/graph_connectivity
    crypta/graph/mrcc/lib
    crypta/graph/fuzzy/lib/tasks/sources/proto
    library/python/statface_client
)

PY_SRCS(
    config.py
    luiger.py

    common/yt_methods.py
    common/__init__.py
    common/dates.py
    common/statistics_sender.py

    tasks/extract.py
    tasks/transform.py
    tasks/evaluate.py

    tasks/sources/geo/__init__.py
    tasks/sources/geo/extract.py
    tasks/sources/geo/geo_operations.pyx
    tasks/sources/geo/constants.py

    tasks/sources/emails/__init__.py
    tasks/sources/emails/additional_utils.py
    tasks/sources/emails/extract_all_emails_task.py
    tasks/sources/emails/process_extracted_logins_task.py
    tasks/sources/emails/extract_email_pairs_by_frag.py

    tasks/sources/households/__init__.py
    tasks/sources/households/task.py

    tasks/sources/reqans/__init__.py
    tasks/sources/reqans/task.py

    tasks/sources/ssid/__init__.py
    tasks/sources/ssid/daily_task.py
    tasks/sources/ssid/monthly_task.py
    tasks/sources/ssid/native_operations.pyx

    tasks/sources/visitlog_logins/__init__.py
    tasks/sources/visitlog_logins/extract.py
    tasks/sources/visitlog_logins/native_operations.pyx

    tasks/sources/heuristic/__init__.py
    tasks/sources/heuristic/extract.py
    tasks/sources/heuristic/native_operations.pyx

    tasks/classifier/__init__.py
    tasks/classifier/enricher.py
    tasks/classifier/collect.py
    tasks/classifier/classifier.py
    tasks/classifier/counters.py
    tasks/classifier/export.py

    tasks/metrics/__init__.py
    tasks/metrics/all_metrics_task.py
    tasks/metrics/components_size_metrics.py
    tasks/metrics/export_size_metrics.py
    tasks/metrics/score_metrics.py
    tasks/metrics/statface.py
    tasks/metrics/connected_components.py
)

RESOURCE(
    yql/bs_watch_log.yql  yql/bs_watch_log
    yql/exact_mathcing_proof.yql  yql/exact_mathcing_proof
    yql/yuid_enricher.yql  yql/yuid_enricher
    yql/export_ssid_yuids.yql  yql/export_ssid_yuids
    yql/export_ssid_devid_day_table.yql  yql/export_ssid_devid_day_table
    yql/export_hh.yql yql/export_hh
    yql/reqans.yql  yql/reqans
    yql/bayes_table.yql  yql/bayes_table
    yql/export_sup.yql yql/export_sup
    yql/export_external.yql yql/export_external
    yql/components_preprocessing.yql yql/components_preprocessing
    yql/components_postprocessing.yql yql/components_postprocessing
    yql/components_size.yql yql/components_size
    yql/score_metrics.yql yql/score_metrics
)

SRCS(
    tasks/sources/geo/geo_utils.cpp
)

END()
