import datetime
import logging
import sys

import crypta.lib.python.bt.tasks.tool2 as task
from crypta.lib.python.getoptpb import ParsePbOptions

import crypta.graph.households.proto.config_pb2 as proto_config

import crypta.graph.households.data_import.watchlog.lib  # noqa
import crypta.graph.households.data_import.increment_day.lib  # noqa
import crypta.graph.households.hh_composition.lib  # noqa
import crypta.graph.households.hh_match.lib  # noqa

import crypta.lib.python.bt.conf.conf as conf


def main():
    if not logging.root.handlers:
        logging.root.addHandler(logging.StreamHandler(sys.stderr))
    conf.use_proto(ParsePbOptions(proto_config.THouseholdsConfig))

    if conf.proto.Date == "today":
        conf.proto.Date = datetime.datetime.now().strftime("%Y-%m-%d")

    sys.exit(task.main(conf.proto))


if __name__ == "__main__":
    main()
