from crypta.graph.households.lib import HouseHoldsStream


class IncrementDay(HouseHoldsStream):

    """ households Run YQL query to increment day """

    @property
    def query_template(self):
        return "increment_day.sql.j2"

    def _after_run(self, result):
        if result is None:
            return

        if hasattr(result, "table"):
            # yql client
            processed_tables = result.table
            data = (path[0] for path in processed_tables.rows)
        else:
            # embeded yql (in tests)
            processed_tables = result[0]
            assert processed_tables["Label"] == "processed tables"
            data = (path[0] for path in processed_tables["Write"][0]["Data"])

        for table in data:
            self.yt.remove(table)
        self.yt.write_table("{}_dates".format(self.get_processed_tables_storage()), [], format="json")
