{% include '/templates/stream.sql.j2' %}
-- ========================================================================= --

{#
-- PRAGMA yt.ExpirationInterval = '95d';
PRAGMA yt.ExpirationDeadline = '{{
    datetime.datetime.strftime(
        datetime.datetime.strptime(date, "%Y-%m-%d")
            + datetime.timedelta(days=95),
        "%Y-%m-%d"
    )
}}';
#}

$processed_tables_table = '{{ processed_tables }}';
$processed_dates = '{{ processed_tables }}_dates';
$fresh_tables_input = '{{ household_dir }}/stream';
$result_tables_output = '{{ household_dir }}/storage';

DEFINE ACTION $increment_day($tables, $ready_tables) AS

    $days = (SELECT AGGREGATE_LIST_DISTINCT(dt) FROM $processed_dates);

    DEFINE ACTION $process_day($day) AS
        $output = $result_tables_output || '/' || $day;

        $input_tables = EvaluateExpr(CASE
            WHEN ListHas(Unwrap($ready_tables), $output)
                THEN ListExtend(Unwrap($tables), AsList($output))
            ELSE $tables
        END);

        INSERT INTO $output WITH TRUNCATE
        SELECT $day AS dt, yuid, is_tv, ip, SUM(hits) AS hits
        FROM EACH($input_tables)
        WHERE dt == $day
        GROUP BY is_tv, yuid, ip
        ORDER BY dt, is_tv, yuid, ip;

    END DEFINE;
    EVALUATE FOR $day IN $days DO $process_day($day);

    SELECT path
    FROM (SELECT Unwrap($tables) AS unprocessed)
    FLATTEN LIST BY unprocessed AS path
    INTO RESULT `processed tables`;

END DEFINE;

DEFINE ACTION $cut_processed_tables($date) AS
    $get_date = Re2::Capture(@@.*(?P<dt>\d{4}-\d{2}-\d{2}).*@@);
    $predicat = ($value) -> {
        $dt = $get_date($value).dt;
        RETURN (CAST($date AS Date) - CAST($dt AS Date) < DateTime::IntervalFromDays(3));
    };

    INSERT INTO $processed_tables_table WITH TRUNCATE
    SELECT DISTINCT path FROM $processed_tables_table
    WHERE $predicat(path);
END DEFINE;

$unpocessed_tables = (SELECT tables FROM $get_all_tables_list($fresh_tables_input));
$result_tables = (SELECT tables FROM $get_all_tables_list($result_tables_output));

EVALUATE IF ListLength($unpocessed_tables) > 0 DO
    $increment_day($unpocessed_tables, $result_tables);

DO $cut_processed_tables('{{ date }}');
