{% include '/templates/stream.sql.j2' %}
-- ========================================================================= --

$watch_log_stream = '//home/logfeller/logs/bs-watch-log/stream/5min';
$processed_tables_table = '{{ processed_tables }}';
$fresh_tables_output = '{{ household_dir }}/stream';

$df = DateTime::Format('%Y-%m-%d');
DEFINE SUBQUERY $watchlog_query($tables) AS
    SELECT
        $df(DateTime::FromSeconds(
            CAST(WeakField(_logfeller_timestamp, 'Uint64') AS UInt32)
        )) AS dt,
        CAST(WeakField(uniqid, 'String') AS Uint64) ?? 0 AS yuid,
        UserAgent::Parse(WeakField(useragent, 'String')).isTV AS is_tv,
        Ip::FromString(WeakField(clientip6, 'String')) AS ip
    FROM EACH($tables)
    WHERE browserinfo NOT REGEXP @@(^|\:)cy\:2($|\:)@@  -- CRYPTR-1978
END DEFINE;

$unpocessed_tables = (
    SELECT tables FROM $get_unprocessed_tables(
        $watch_log_stream, $processed_tables_table
    )
);

EVALUATE IF ListLength($unpocessed_tables) > 0 DO $parse_stream(
    $unpocessed_tables,
    $watchlog_query,
    $fresh_tables_output,
    '{{ uniqid }}'
);
