from crypta.graph.households.lib import HouseHoldsQuery


class CompositionHH(HouseHoldsQuery):

    """ households Run YQL query to make hh composition """

    @property
    def query_template(self):
        return "composition.sql.j2"

    def get_libs(self):
        """ Return list of libraries with extra UD(A)Fs """
        libs = super(CompositionHH, self).get_libs()
        libs.append({"name": "composition.py", "content": "composition.py", "disposition": "resource", "type": "file"})
        return libs

    def run(self, *args, **kwargs):
        super(CompositionHH, self).run(*args, **kwargs)
        self.set_generate_date()
