from crypta.graph.households.lib import HouseHoldsQuery
from crypta.graph.mrcc.lib import ExtendedMRConnectedComponentsYT

# from crypta.lib.python.bt.workflow import IndependentTask

import crypta.lib.python.bt.conf.conf as conf


class PrepareHH(HouseHoldsQuery):

    """ households Run YQL query to prepare CryptaId -- SmartTV matching """

    @property
    def query_template(self):
        return "prepare.sql.j2"

    def set_generate_date(self):
        path = "{graph_output_dir}/v2/matching/vertices_no_multi_profile_by_id_type".format(
            graph_output_dir=self.get_graph_output_dir()
        )
        attributes = self.yt.get("{path}/@".format(path=path))
        self.yt.set(
            "{path}/@generate_date".format(path=self.get_households_base_dir()), attributes.get("generate_date")
        )
        self.yt.set("{path}/@run_date".format(path=self.get_households_base_dir()), self.date)

    def run(self, *args, **kwargs):
        super(PrepareHH, self).run(*args, **kwargs)
        self.set_generate_date()


class FinishHH(HouseHoldsQuery):

    """ households Run YQL query to finish create households """

    @property
    def query_template(self):
        return "finish.sql.j2"

    def run(self, *args, **kwargs):
        super(FinishHH, self).run(*args, **kwargs)
        self.set_generate_date()


class FindMrcc(HouseHoldsQuery):

    """ households Run MRCC on crypta_id---crypta_id """

    def get_source_table(self):
        return "{household_dir}/workdir/crypta_id_crypta_id".format(household_dir=self.get_households_base_dir())

    def run(self, *args, **kwargs):
        client_config = {
            "proxy": self.yt_proxy,
            "transaction_id": str(self.transaction_id),
            "token": self.get_token(),
            "pool": self.pool or conf.yt.pool,
        }
        client = self.yt
        for key, value in client_config.items():
            setattr(client, key, value)
        mrcc = ExtendedMRConnectedComponentsYT(client)
        converged = mrcc.find_connected_components(
            source=self.get_source_table(),
            destination=None,
            u_name="id1",
            v_name="id2",
            component_id="hhid",
            max_iter=15,
        )
        assert converged, "Not converged MRCC"
        return converged


class FinishHHx(FinishHH):

    """ Run all hh match """

    def get_source_table(self):
        return "{household_dir}/workdir/crypta_id_crypta_id".format(household_dir=self.get_households_base_dir())

    def run_mrcc(self, *args, **kwargs):
        client_config = {
            "proxy": self.yt_proxy,
            "transaction_id": str(self.transaction_id),
            "token": self.get_token(),
            "pool": self.pool or conf.yt.pool,
        }
        client = self.yt
        for key, value in client_config.items():
            setattr(client, key, value)
        mrcc = ExtendedMRConnectedComponentsYT(client)
        converged = mrcc.find_connected_components(
            source=self.get_source_table(),
            destination=None,
            u_name="id1",
            v_name="id2",
            component_id="hhid",
            max_iter=15,
        )
        assert converged, "Not converged MRCC"
        return converged

    def run(self, *args, **kwargs):
        """ TODO: make it with bt """
        self.run_mrcc(*args, **kwargs)
        super(FinishHHx, self).run(*args, **kwargs)
