package ru.yandex.crypta.graph2.dao;

import ru.yandex.crypta.graph2.dao.yql.Yql;
import ru.yandex.crypta.graph2.dao.yt.YtCypressHelper;
import ru.yandex.crypta.graph2.dao.yt.YtTablesHelper;
import ru.yandex.crypta.graph2.dao.yt.YtTransactionsHelper;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOps;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOpsImpl;
import ru.yandex.crypta.graph2.dao.yt.ops.YtOpsParams;
import ru.yandex.inside.yt.kosher.Yt;

public class Dao {
    private Yt yt;
    private Yql yql;
    private YtOps ytOps;
    private YtCypressHelper ytCypressHelper;
    private YtTransactionsHelper ytTransactionsHelper;
    private YtTablesHelper ytTablesHelper;

    public Dao(Yt yt, Yql yql, YtOps ytOps, YtCypressHelper ytCypressHelper, YtTransactionsHelper ytTransactionsHelper, YtTablesHelper ytTablesHelper) {
        this.yt = yt;
        this.yql = yql;
        this.ytOps = ytOps;
        this.ytCypressHelper = ytCypressHelper;
        this.ytTransactionsHelper = ytTransactionsHelper;
        this.ytTablesHelper = ytTablesHelper;
    }

    public Dao(Yt yt, Yql yql, YtOpsParams ytOpsParams) {
        this.yt = yt;
        this.yql = yql;
        this.ytOps = new YtOpsImpl(yt, ytOpsParams);
        this.ytCypressHelper = new YtCypressHelper(yt);
        this.ytTransactionsHelper = new YtTransactionsHelper(yt);
        this.ytTablesHelper = new YtTablesHelper(yt);
    }

    public Yt yt() {
        return yt;
    }

    public Yql yql() {
        return yql;
    }

    public YtOps ytOps() {
        return ytOps;
    }

    public YtCypressHelper ytCypress() {
        return ytCypressHelper;
    }

    public YtTransactionsHelper ytTr() {
        return ytTransactionsHelper;
    }

    public YtTablesHelper ytTables() {
        return ytTablesHelper;
    }
}
