package ru.yandex.crypta.graph2.dao.yql;

import static ru.yandex.crypta.graph2.dao.yt.YtConfig.getYtPool;
import static ru.yandex.crypta.graph2.utils.EnvUtils.getEnvOrDefault;
import static ru.yandex.crypta.graph2.utils.EnvUtils.getEnvOrThrow;

public class YqlConfig {

    public static String getYqlUrl() {
        return getEnvOrDefault("YQL_URL", "yql.yandex.net:443");
    }

    public static String getYqlYtCluster() {
        return getEnvOrDefault("YQL_YT_CLUSTER", "hahn");
    }

    public static String getYqlToken() {
        return getEnvOrThrow("YQL_TOKEN");
    }

    public static Yql getYql() {
        return new YqlImpl(getYqlUrl(), getYqlYtCluster(), getYqlToken(), getYtPool());
    }
}
