package ru.yandex.crypta.graph2.dao.yt.bendable;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;
import ru.yandex.inside.yt.kosher.impl.ytree.object.serializers.YTreeObjectSerializer;
import ru.yandex.misc.reflection.ClassX;

public class YTreeSerializerCachingFactory implements YTreeSerializerFactory {

    private Map<Class, YTreeObjectSerializer> cache = new ConcurrentHashMap<>();

    @Override
    public <T> YTreeObjectSerializer<T> createSerializer(Class<T> clazz) {
        return cache.computeIfAbsent(clazz,
                (x) -> {
                    ClassX classX = ClassX.wrap(clazz);
                    if (classX.hasAnnotationInAnnotatedOrItsAnnotations(YTreeObject.class)) {
                        return new YTreeObjectSerializer(classX.getClazz());
                    } else {
                        throw new IllegalArgumentException("Can't construct serializer for " + classX);
                    }
                }
        );
    }
}
