package ru.yandex.crypta.graph2.dao.yt.bendable;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.impl.ytree.object.YTreeSerializer;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class YsonCachedSerializerSupport  {

    // this part is not serializable, thus created at YT side
    // but it supports serializers cache, thus it's ok
    private static YTreeSerializerCachingFactory serializerFactory = new YTreeSerializerCachingFactory();

    @SuppressWarnings("unchecked")
    public <T> T parse(YTreeMapNode rec, Class<T> clazz) {
        YTreeSerializer<T> serializer = serializerFactory.createSerializer(clazz);
        return serializer.deserialize(rec);
    }

    public <T> IteratorF<T> parse(IteratorF<YTreeMapNode> recs, Class<T> clazz) {
        return recs.map(r -> parse(r, clazz));
    }

    public <T> ListF<T> parse(CollectionF<YTreeMapNode> recs, Class<T> clazz) {
        return recs.map(r -> parse(r, clazz));
    }

    @SuppressWarnings("unchecked")
    public <T> YTreeMapNode serialize(T entity) {
        YTreeSerializer serializer = serializerFactory.createSerializer(entity.getClass());
        YTreeBuilder builder = YTree.builder();
        serializer.serialize(entity, builder);
        return builder.build().mapNode();
    }

    public <T> YTreeSerializer getSerializer(Class<T> clazz) {
        return serializerFactory.createSerializer(clazz);
    }

}
