package ru.yandex.crypta.graph2.dao.yt.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.yt.kosher.operations.Yield;

public class LocalYield<T> implements Yield<T> {

    private Map<Integer, List<T>> result = new HashMap<>();

    @Override
    public void yield(int index, T value) {
        result.putIfAbsent(index, new ArrayList<>());
        result.get(index).add(value);
    }

    @Override
    public void close() throws IOException {

    }

    public ListF<T> getRecsByIndex(int index) {
        return Cf.wrap(result.getOrDefault(index, List.of()));
    }

    public ListF<T> getAllRecs() {
        return Cf.wrap(result.values()
                .stream()
                .flatMap(Collection::stream)
                .collect(Collectors.toList())
        );
    }
}
