package ru.yandex.crypta.graph2.dao.yt.local.fastyt;

import java.nio.file.Path;

import ru.yandex.crypta.graph2.dao.Dao;
import ru.yandex.crypta.graph2.dao.yql.YqlStub;
import ru.yandex.crypta.graph2.dao.yt.YtCypressHelper;
import ru.yandex.crypta.graph2.dao.yt.YtTablesHelper;
import ru.yandex.crypta.graph2.dao.yt.YtTransactionsHelper;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.client.CypressLocalFsImpl;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.client.YtAclFakeImpl;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.client.YtFilesFakeImpl;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.client.YtOperationsFakeImpl;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.client.YtTablesLocalImpl;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.client.YtTransactionsFakeImpl;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.fs.FileBasedLocalYtDataLayer;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.fs.InMemoryLocalYtDataLayer;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.fs.LocalYtDataLayer;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.ops.YtOpsLocalImpl;
import ru.yandex.inside.yt.kosher.impl.YtImpl;
import ru.yandex.inside.yt.kosher.impl.YtUtils;
import ru.yandex.inside.yt.kosher.impl.operations.jars.JarsProcessorStub;

public class LocalYtFactory {

    public static Dao createFileBasedLocalDao(Path baseDir) {
        LocalYtDataLayer tablesDataLayer = new FileBasedLocalYtDataLayer(baseDir);
        return createLocalDao(tablesDataLayer, baseDir);
    }

    public static Dao createInMemoryLocalDao(Path baseDir) {
        LocalYtDataLayer tablesDataLayer = new InMemoryLocalYtDataLayer();
        return createLocalDao(tablesDataLayer, baseDir);
    }

    public static Dao createLocalDao(LocalYtDataLayer tablesDataLayer, Path baseDir) {
        YtOpsLocalImpl ytOpsLocal = new YtOpsLocalImpl(tablesDataLayer);

        // tables data and tables metadata can be stored in different data layers
        // we choose file based data layer for metadata by default
        FileBasedLocalYtDataLayer cypressDataLayer = new FileBasedLocalYtDataLayer(baseDir);
        CypressLocalFsImpl cypress = new CypressLocalFsImpl(cypressDataLayer, ytOpsLocal);

        YtImpl yt = new YtImpl(
                cypress,
                new YtAclFakeImpl(),
                new YtFilesFakeImpl(),
                new YtTablesLocalImpl(tablesDataLayer),
                new YtOperationsFakeImpl(),
                new YtTransactionsFakeImpl(),
                new JarsProcessorStub(),
                YtUtils.getDefaultConfiguration("", "")
        );

        return new Dao(
                yt,
                YqlStub.getInstance(),
                new YtOpsLocalImpl(tablesDataLayer),
                new YtCypressHelper(yt),
                new YtTransactionsHelper(yt),
                new YtTablesHelper(yt)
        );
    }
}
