package ru.yandex.crypta.graph2.dao.yt.local.fastyt.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.fs.FileBasedLocalYtDataLayer;
import ru.yandex.crypta.graph2.dao.yt.local.fastyt.ops.YtOpsLocalImpl;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.BatchRequest;
import ru.yandex.inside.yt.kosher.cypress.Cypress;
import ru.yandex.inside.yt.kosher.cypress.CypressNodeType;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeStringNode;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.yt.ytclient.proxy.request.CopyNode;
import ru.yandex.yt.ytclient.proxy.request.CreateNode;
import ru.yandex.yt.ytclient.proxy.request.ExistsNode;
import ru.yandex.yt.ytclient.proxy.request.GetNode;
import ru.yandex.yt.ytclient.proxy.request.LinkNode;
import ru.yandex.yt.ytclient.proxy.request.ListNode;
import ru.yandex.yt.ytclient.proxy.request.LockNode;
import ru.yandex.yt.ytclient.proxy.request.MasterReadKind;
import ru.yandex.yt.ytclient.proxy.request.MoveNode;
import ru.yandex.yt.ytclient.proxy.request.RemoveNode;
import ru.yandex.yt.ytclient.proxy.request.SetNode;

import static java.nio.file.StandardOpenOption.CREATE;
import static java.nio.file.StandardOpenOption.TRUNCATE_EXISTING;
import static java.nio.file.StandardOpenOption.WRITE;

public class CypressLocalFsImpl implements Cypress {


    private YtOpsLocalImpl ytOpsLocal;
    private FileBasedLocalYtDataLayer dataLayer;

    public CypressLocalFsImpl(FileBasedLocalYtDataLayer dataLayer, YtOpsLocalImpl ytOpsLocal) {
        this.dataLayer = dataLayer;
        this.ytOpsLocal = ytOpsLocal;
    }


    @Override
    public void create(CreateNode req) {
        YPath path = req.getPath();
        CypressNodeType type = req.getType().toCypressNodeType();
        boolean recursive = req.isRecursive();
        try {
            Path fsPath = dataLayer.convertToLocalNode(path);
            if (type == CypressNodeType.MAP) {
                Files.createDirectories(fsPath);
            } else if (type == CypressNodeType.TABLE) {
                if (recursive) {
                    Files.createDirectories(fsPath.getParent());
                }
                recreateFile(fsPath);
            }
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }

    }

    private void recreateFile(Path path, FileAttribute<?>... attrs) throws IOException {
        EnumSet<StandardOpenOption> options = EnumSet.of(TRUNCATE_EXISTING, CREATE, WRITE);
        Files.newByteChannel(path, options, attrs).close();
    }

    @Override
    public void remove(RemoveNode req) {

    }

    @Override
    public void set(SetNode req) {

    }

    @Override
    public YTreeNode get(GetNode getNode) {
        return null;
    }

    @Override
    public List<YTreeStringNode> list(Optional<GUID> transactionId, boolean pingAncestorTransactions, YPath path, Optional<MasterReadKind> readFrom, Collection<String> attributes) {
        try {
            Path fsPath = dataLayer.convertToLocalNode(path);
            if (Files.isDirectory(fsPath)) {
                try (var stream = Files.list(fsPath)) {
                    List<YTreeStringNode> children = stream
                            .map(x -> YTree.stringNode(x.getFileName().toString()))
                            .collect(Collectors.toList());
                    return Cf.wrap(children);
                }
            } else {
                throw new IllegalArgumentException("Path type is not supported: " + fsPath);
            }
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    @Override
    public List<YTreeStringNode> list(ListNode listNode) {
      return null;
    }

    @Override
    public GUID lock(LockNode req) {
        return null;
    }

    private GUID copyImpl(YPath source, YPath destination) {
        ytOpsLocal.mergeChunksOperation(Cf.list(source), destination).runSync();
        Path sourceFs = dataLayer.convertToLocalNode(source);
        Path targetFs = dataLayer.convertToLocalNode(destination);

        try {
            Files.copy(sourceFs, targetFs, StandardCopyOption.REPLACE_EXISTING);
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }

        Option<YTreeMapNode> metadata = dataLayer.getMetadata(source);
        if (metadata.isPresent()) {
            dataLayer.setMetadata(destination, metadata.get());
        }

        return GUID.create();
    }

    @Override
    public GUID copy(CopyNode copyNode) {
        return copyImpl(copyNode.getSource(), copyNode.getDestination());
    }

    @Override
    public GUID link(LinkNode linkNode) {
        return null;
    }

    @Override
    public void move(MoveNode moveNode) {
        copyImpl(moveNode.getSource(), moveNode.getDestination());
        // TODO: remove source
    }

    @Override
    public boolean exists(ExistsNode existsNode) {
        return true;
    }

    @Override
    public boolean exists(@Nullable GUID transactionId, boolean pingAncestorTransactions, YPath path, @Nullable MasterReadKind masterReadKind) {

        Path fsPath = dataLayer.convertToLocalNode(path);
        return Files.exists(fsPath);

    }

    @Override
    public void concatenate(@Nullable GUID transactionId, boolean pingAncestorTransactions, List<YPath> src, YPath dst) {
        ytOpsLocal.mergeChunksOperation(Cf.wrap(src), dst).runSync();
    }


    @Override
    public BatchRequest executeBatch(GUID transactionId, boolean pingAncestorTransactions, Integer concurrency)
    {
        return null;
    }

    @Override
    public YPath putToCache(YPath filePath, YPath cachePath, String md5)
    {
        return null;
    }

    @Override
    public Optional<YPath> getFromCache(YPath cachePath, String md5)
    {
        return Optional.empty();
    }
}

