package ru.yandex.crypta.graph2.dao.yt.local.fastyt.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

import ru.yandex.crypta.graph2.dao.yt.local.fastyt.fs.LocalYtDataLayer;
import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.common.http.Compressor;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.tables.CloseableIterator;
import ru.yandex.inside.yt.kosher.tables.ReplicaMode;
import ru.yandex.inside.yt.kosher.tables.TableReaderOptions;
import ru.yandex.inside.yt.kosher.tables.TableWriterOptions;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YtTables;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.misc.ExceptionUtils;

public class YtTablesLocalImpl implements YtTables {

    private LocalYtDataLayer dataLayer;

    public YtTablesLocalImpl(LocalYtDataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    public LocalYtDataLayer getDataLayer() {
        return dataLayer;
    }

    @Override
    public <T> void write(Optional<GUID> transactionId, boolean pingAncestorTransactions, YPath path, YTableEntryType<T> entryType, Iterator<T> entries, TableWriterOptions options) {

        OutputStream outputStream = dataLayer.createOutputStream(path);
        try (Yield<T> yield = entryType.yield(new OutputStream[]{outputStream})) {
            entries.forEachRemaining(yield::yield);
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }

    }

    @Override
    public <T, U> U read(Optional<GUID> transactionId, boolean pingAncestorTransactions, YPath path, YTableEntryType<T> entryType, Function<Iterator<T>, U> callback, TableReaderOptions options) {

        try (InputStream inputStream = dataLayer.createInputStream(path)) {
            Iterator<T> iterator = entryType.iterator(inputStream);
            return callback.apply(iterator);

        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }

    }

    @Override
    public <T> CloseableIterator<T> read(Optional<GUID> transactionId, boolean pingAncestorTransactions, YPath path, YTableEntryType<T> entryType, TableReaderOptions options) {
        InputStream inputStream = dataLayer.createInputStream(path);
        return entryType.iterator(inputStream);
    }

    @Override
    public <T, U> U selectRows(Optional<GUID> txId, String query, Optional<Instant> timestamp, Optional<Integer> inputRowLimit, Optional<Integer> outputRowLimit, boolean enableCodeCache, YTableEntryType<T> entryType, Function<Iterator<T>, U> callback) {
        return null;
    }

    @Override
    public <TInput, TOutput, T> T lookupRows(Optional<GUID> txId, YPath path, Optional<Instant> timestamp, YTableEntryType<TInput> inputType, Iterable<TInput> keys, YTableEntryType<TOutput> outputType, Function<Iterator<TOutput>, T> callback, Compressor compressor) {
        return null;
    }

    @Override
    public <T> void insertRows(Optional<GUID> txId, YPath path, boolean update, boolean aggregate, boolean requireSyncReplica, YTableEntryType<T> entryType, Iterator<T> iterator, Compressor compressor) {

    }

    @Override
    public <T> void deleteRows(Optional<GUID> txId, YPath path, boolean requireSyncReplica, YTableEntryType<T> entryType, Iterable<T> keys, Compressor compressor) {

    }

    @Override
    public void trimRows(YPath path, long tabletIndex, long trimmedRowCount) {

    }

    @Override
    public void mount(YPath path, Optional<Integer> firstTabletIndex, Optional<Integer> lastTabletIndex, Optional<GUID> cellId) {

    }

    @Override
    public void remount(YPath path, Optional<Integer> firstTabletIndex, Optional<Integer> lastTabletIndex) {

    }

    @Override
    public void unmount(YPath path, Optional<Integer> firstTabletIndex, Optional<Integer> lastTabletIndex, boolean force) {

    }

    @Override
    public void freeze(YPath path, Optional<Integer> firstTabletIndex, Optional<Integer> lastTabletIndex) {

    }

    @Override
    public void unfreeze(YPath path, Optional<Integer> firstTabletIndex, Optional<Integer> lastTabletIndex) {

    }

    @Override
    public void reshard(Optional<GUID> transactionId, boolean pingAncestorTransactions, YPath path, List<List<YTreeNode>> pivotKeys, Optional<Integer> firstTabletIndex, Optional<Integer> lastTabletIndex) {

    }

    @Override
    public void alterTable(YPath path, Optional<Boolean> dynamic, Optional<YTreeNode> schema, Optional<GUID> upstreamReplicaId) {

    }

    @Override
    public void alterTableReplica(GUID replicaId, Optional<ReplicaMode> replicaMode, Optional<Boolean> enabled) {

    }
}
