package ru.yandex.crypta.graph2.dao.yt.local.fastyt.client;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import ru.yandex.inside.yt.kosher.common.GUID;
import ru.yandex.inside.yt.kosher.transactions.Transaction;
import ru.yandex.inside.yt.kosher.transactions.YtTransactions;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class YtTransactionsFakeImpl implements YtTransactions {
    @Override
    public GUID start(Optional<GUID> transactionId, boolean pingAncestorTransactions, Duration timeout, Optional<Instant> deadline, Optional<List<GUID>> prerequisiteTransactions, Map<String, YTreeNode> attributes) {
        if (transactionId.isPresent()) {
            return transactionId.get();
        } else {
            return new TransactionStub().getId();
        }
    }

    @Override
    public void ping(GUID transactionId, boolean pingAncestorTransactions) {

    }

    @Override
    public void commit(GUID transactionId, boolean pingAncestorTransactions, Optional<List<GUID>> prerequisiteTransactions) {

    }

    @Override
    public void abort(GUID transactionId, boolean pingAncestorTransactions) {

    }

    @Override
    public Transaction getTransaction(GUID transactionId) {
        return new TransactionStub(transactionId);
    }

    public static class TransactionStub implements Transaction {

        private GUID id;

        public TransactionStub() {
            id = GUID.create();
        }

        public TransactionStub(GUID id) {
            this.id = id;
        }

        @Override
        public GUID getId() {
            return id;
        }

        @Override
        public Optional<Transaction> getParent() {
            return Optional.empty();
        }

        @Override
        public Instant getStartTime() {
            return null;
        }

        @Override
        public Duration getTimeout() {
            return null;
        }

        @Override
        public Transaction start(boolean pingAncestorTransactions, Duration timeout) {
            return new TransactionStub();
        }

        @Override
        public void ping(boolean pingAncestorTransactions) {

        }

        @Override
        public void commit(boolean pingAncestorTransactions) {

        }

        @Override
        public void abort(boolean pingAncestorTransactions) {

        }
    }
}
