package ru.yandex.crypta.graph2.dao.yt.local.fastyt.fs;

import java.io.InputStream;
import java.io.OutputStream;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class InMemoryLocalYtDataLayer implements LocalYtDataLayer<YPath> {

    private MapF<YPath, InMemoryTable> tables = Cf.hashMap();
    private MapF<YPath, YTreeMapNode> metadataDict = Cf.hashMap();

    @Override
    public InputStream createInputStream(YPath path) {
        YPath key = convertToLocalNode(path);
        InMemoryTable table = tables.getOrElse(key, new InMemoryTable());
        return table.getInputStream();
    }

    @Override
    public OutputStream createOutputStream(YPath path) {
        YPath key = convertToLocalNode(path);
        InMemoryTable table = new InMemoryTable();
        tables.put(key, table);
        return table.getOutputStream();
    }

    @Override
    public void setMetadata(YPath path, YTreeMapNode metadata) {
        YPath key = convertToLocalNode(path);
        metadataDict.put(key, metadata);
    }

    @Override
    public Option<YTreeMapNode> getMetadata(YPath path) {
        YPath key = convertToLocalNode(path);
        return metadataDict.getO(key);
    }

    @Override
    public YPath convertToLocalNode(YPath ypath) {
        return ypath;
    }
}
