package ru.yandex.crypta.graph2.dao.yt.local.fastyt.recs;

import java.io.IOException;

import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;


/**
 * Compatibility layer between yson recs and other types of recs
 *
 * @param <T>
 */
public interface YsonRecsTransformer<T> {

    T fromYson(YTreeMapNode rec);

    YTreeMapNode toYson(T rec, int index);

    default Yield<T> yield(Yield<YTreeMapNode> yield) {
        return new Yield<>() {
            @Override
            public void yield(int index, T value) {
                yield.yield(index, toYson(value, index));
            }

            @Override
            public void close() throws IOException {
                yield.close();
            }
        };
    }

}
