package ru.yandex.crypta.graph2.dao.yt.local.fastyt.recs;

import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.impl.ytree.object.YTreeSerializer;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

/**
 * Converts rec between yson and a class, annotated by @YTreeObject
 *
 * @param <T>
 */
public class YsonToEntityTransformer<T> implements YsonRecsTransformer<T> {

    private final YTreeSerializer<T> serializer;

    public YsonToEntityTransformer(YTreeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public T fromYson(YTreeMapNode rec) {
        return serializer.deserialize(rec);
    }

    @Override
    public YTreeMapNode toYson(T rec, int index) {
        YTreeBuilder builder = YTree.builder();
        serializer.serialize(rec, builder);
        return builder.build().mapNode();
    }
}
