package ru.yandex.crypta.graph2.dao.yt.local.fastyt.recs;

import com.google.protobuf.Message;

import ru.yandex.inside.yt.kosher.impl.ytree.YTreeProtoUtils;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

/**
 * Converts rec between yson and a protobuf message representation
 */
public class YsonToSingleProtoTransformer implements YsonRecsTransformer<Message> {

    private final Message.Builder builder;

    public YsonToSingleProtoTransformer(Message.Builder builder) {
        this.builder = builder;
    }

    @Override
    public Message fromYson(YTreeMapNode rec) {
        builder.clear();
        return YTreeProtoUtils.unmarshal(rec, builder);
    }

    @Override
    public YTreeMapNode toYson(Message rec, int index) {
        return (YTreeMapNode) YTreeProtoUtils.marshal(rec);
    }


}
